/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.app;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.Ignite;
import org.apache.ignite.Ignition;
import org.apache.ignite.internal.app.IgniteImpl;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.properties.IgniteProductVersion;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.lang.NodeStoppingException;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.Nullable;

public class IgnitionImpl
implements Ignition {
    private static final IgniteLogger LOG = Loggers.forClass(IgnitionImpl.class);
    private static final String[] BANNER = new String[]{"", "           #              ___                         __", "         ###             /   |   ____   ____ _ _____ / /_   ___", "     #  #####           / /| |  / __ \\ / __ `// ___// __ \\ / _ \\", "   ###  ######         / ___ | / /_/ // /_/ // /__ / / / // ___/", "  #####  #######      /_/  |_|/ .___/ \\__,_/ \\___//_/ /_/ \\___/", "  #######  ######            /_/", "    ########  ####        ____               _  __           _____", "   #  ########  ##       /  _/____ _ ____   (_)/ /_ ___     |__  /", "  ####  #######  #       / / / __ `// __ \\ / // __// _ \\     /_ <", "   #####  #####        _/ / / /_/ // / / // // /_ / ___/   ___/ /", "     ####  ##         /___/ \\__, //_/ /_//_/ \\__/ \\___/   /____/", "       ##                  /____/\n"};
    private static final Map<String, IgniteImpl> nodes = new ConcurrentHashMap<String, IgniteImpl>();
    private static final Map<String, IgniteImpl> readyForInitNodes = new ConcurrentHashMap<String, IgniteImpl>();

    public CompletableFuture<Ignite> start(String nodeName, @Nullable Path cfgPath, Path workDir) {
        return this.start(nodeName, cfgPath, workDir, IgnitionImpl.defaultServiceClassLoader());
    }

    public CompletableFuture<Ignite> start(String nodeName, @Nullable Path cfgPath, Path workDir, @Nullable ClassLoader serviceLoaderClassLoader) {
        try {
            return IgnitionImpl.doStart(nodeName, cfgPath == null ? null : Files.readString(cfgPath), workDir, serviceLoaderClassLoader);
        }
        catch (IOException e) {
            throw new IgniteException("Unable to read user specific configuration.", (Throwable)e);
        }
    }

    public CompletableFuture<Ignite> start(String nodeName, @Nullable URL cfgUrl, Path workDir) {
        CompletableFuture<Ignite> completableFuture;
        block9: {
            if (cfgUrl == null) {
                return this.start(nodeName, workDir);
            }
            InputStream cfgStream = cfgUrl.openStream();
            try {
                completableFuture = this.start(nodeName, cfgStream, workDir);
                if (cfgStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (cfgStream != null) {
                        try {
                            cfgStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IgniteException("Unable to read user specific configuration.", (Throwable)e);
                }
            }
            cfgStream.close();
        }
        return completableFuture;
    }

    public CompletableFuture<Ignite> start(String nodeName, @Nullable InputStream cfg, Path workDir) {
        try {
            return IgnitionImpl.doStart(nodeName, cfg == null ? null : new String(cfg.readAllBytes(), StandardCharsets.UTF_8), workDir, IgnitionImpl.defaultServiceClassLoader());
        }
        catch (IOException e) {
            throw new IgniteException("Unable to read user specific configuration.", (Throwable)e);
        }
    }

    public CompletableFuture<Ignite> start(String nodeName, Path workDir) {
        return IgnitionImpl.doStart(nodeName, null, workDir, IgnitionImpl.defaultServiceClassLoader());
    }

    public void stop(String nodeName) {
        readyForInitNodes.remove(nodeName);
        nodes.computeIfPresent(nodeName, (name, node) -> {
            node.stop();
            return null;
        });
    }

    public void init(String nodeName, Collection<String> metaStorageNodenodeNames, String clusterName) {
        this.init(nodeName, metaStorageNodenodeNames, List.of(), clusterName);
    }

    public void init(String nodeName, Collection<String> metaStorageNodeNames, Collection<String> cmgNodeNames, String clusterName) {
        IgniteImpl node = readyForInitNodes.get(nodeName);
        if (node == null) {
            throw new IgniteException("Node \"" + nodeName + "\" has not been started");
        }
        try {
            node.init(metaStorageNodeNames, cmgNodeNames, clusterName);
        }
        catch (NodeStoppingException e) {
            throw new IgniteException("Node stop detected during init", (Throwable)e);
        }
    }

    private static ClassLoader defaultServiceClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private static CompletableFuture<Ignite> doStart(String nodeName, @Language(value="HOCON") @Nullable String cfgContent, Path workDir, @Nullable ClassLoader serviceLoaderClassLoader) {
        if (nodeName.isEmpty()) {
            throw new IllegalArgumentException("Node name must not be null or empty.");
        }
        IgniteImpl nodeToStart = new IgniteImpl(nodeName, workDir, serviceLoaderClassLoader);
        IgniteImpl prevNode = nodes.putIfAbsent(nodeName, nodeToStart);
        if (prevNode != null) {
            String errMsg = "Node already exists [name=" + nodeName + "]";
            LOG.debug(errMsg, new Object[0]);
            throw new IgniteException(errMsg);
        }
        IgnitionImpl.ackBanner();
        try {
            CompletionStage future = nodeToStart.start(cfgContent).handle((ignite, e) -> {
                if (e == null) {
                    IgnitionImpl.ackSuccessStart();
                    return ignite;
                }
                throw IgnitionImpl.handleStartException(nodeName, e);
            });
            readyForInitNodes.put(nodeName, nodeToStart);
            return future;
        }
        catch (Exception e2) {
            throw IgnitionImpl.handleStartException(nodeName, e2);
        }
    }

    private static IgniteException handleStartException(String nodeName, Throwable e) {
        readyForInitNodes.remove(nodeName);
        nodes.remove(nodeName);
        if (e instanceof IgniteException) {
            return (IgniteException)e;
        }
        return new IgniteException(e);
    }

    private static void ackSuccessStart() {
        LOG.info("Apache Ignite started successfully!", new Object[0]);
    }

    private static void ackBanner() {
        String banner = String.join((CharSequence)System.lineSeparator(), BANNER);
        String padding = " ".repeat(22);
        String version = "Apache Ignite ver. " + IgniteProductVersion.CURRENT_VERSION;
        LOG.info("{}" + System.lineSeparator() + "{}{}" + System.lineSeparator(), new Object[]{banner, padding, version});
    }
}

