/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.proj4j.proj;

import org.locationtech.proj4j.ProjCoordinate;
import org.locationtech.proj4j.proj.Projection;

public class NicolosiProjection
extends Projection {
    private static final double EPS = 1.0E-10;

    @Override
    public ProjCoordinate project(double lplam, double lpphi, ProjCoordinate out) {
        if (Math.abs(lplam) < 1.0E-10) {
            out.x = 0.0;
            out.y = lpphi;
        } else if (Math.abs(lpphi) < 1.0E-10) {
            out.x = lplam;
            out.y = 0.0;
        } else if (Math.abs(Math.abs(lplam) - 1.5707963267948966) < 1.0E-10) {
            out.x = lplam * Math.cos(lpphi);
            out.y = 1.5707963267948966 * Math.sin(lpphi);
        } else if (Math.abs(Math.abs(lpphi) - 1.5707963267948966) < 1.0E-10) {
            out.x = 0.0;
            out.y = lpphi;
        } else {
            double tb = 1.5707963267948966 / lplam - lplam / 1.5707963267948966;
            double c = lpphi / 1.5707963267948966;
            double sp = Math.sin(lpphi);
            double d = (1.0 - c * c) / (sp - c);
            double r2 = tb / d;
            r2 *= r2;
            double m = (tb * sp / d - 0.5 * tb) / (1.0 + r2);
            double n = (sp / r2 + 0.5 * d) / (1.0 + 1.0 / r2);
            double x = Math.cos(lpphi);
            x = Math.sqrt(m * m + x * x / (1.0 + r2));
            out.x = 1.5707963267948966 * (m + (lplam < 0.0 ? -x : x));
            double y = Math.sqrt(n * n - (sp * sp / r2 + d * sp - 1.0) / (1.0 + 1.0 / r2));
            out.y = 1.5707963267948966 * (n + (lpphi < 0.0 ? y : -y));
        }
        return out;
    }

    @Override
    public String toString() {
        return "Nicolosi Globular";
    }
}

