/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.shaded.it.unimi.dsi.fastutil.objects;

import java.util.Comparator;

public final class ObjectHeaps {
    private ObjectHeaps() {
    }

    public static <K> int downHeap(K[] heap, int size, int i, Comparator<? super K> c) {
        assert (i < size);
        K e = heap[i];
        if (c == null) {
            int child;
            while ((child = (i << 1) + 1) < size) {
                K t2 = heap[child];
                int right = child + 1;
                if (right < size && ((Comparable)heap[right]).compareTo(t2) < 0) {
                    child = right;
                    t2 = heap[child];
                }
                if (((Comparable)e).compareTo(t2) > 0) {
                    heap[i] = t2;
                    i = child;
                    continue;
                }
                break;
            }
        } else {
            int child;
            while ((child = (i << 1) + 1) < size) {
                K t3 = heap[child];
                int right = child + 1;
                if (right < size && c.compare(heap[right], t3) < 0) {
                    child = right;
                    t3 = heap[child];
                }
                if (c.compare(e, t3) > 0) {
                    heap[i] = t3;
                    i = child;
                    continue;
                }
                break;
            }
        }
        heap[i] = e;
        return i;
    }

    public static <K> int upHeap(K[] heap, int size, int i, Comparator<K> c) {
        assert (i < size);
        K e = heap[i];
        if (c == null) {
            int parent;
            K t2;
            while (i != 0 && ((Comparable)(t2 = heap[parent = i - 1 >>> 1])).compareTo(e) > 0) {
                heap[i] = t2;
                i = parent;
            }
        } else {
            int parent;
            K t3;
            while (i != 0 && c.compare(t3 = heap[parent = i - 1 >>> 1], e) > 0) {
                heap[i] = t3;
                i = parent;
            }
        }
        heap[i] = e;
        return i;
    }

    public static <K> void makeHeap(K[] heap, int size, Comparator<K> c) {
        int i = size >>> 1;
        while (i-- != 0) {
            ObjectHeaps.downHeap(heap, size, i, c);
        }
    }
}

