/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.util;

import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.ignite3.internal.sql.engine.QueryCancelledException;
import org.apache.ignite3.internal.sql.engine.exec.AsyncDataCursor;
import org.apache.ignite3.internal.util.AsyncWrapper;
import org.apache.ignite3.internal.util.CompletableFutures;

public class IteratorToDataCursorAdapter<T>
extends AsyncWrapper<T>
implements AsyncDataCursor<T> {
    private final CompletableFuture<?> initialized;

    public IteratorToDataCursorAdapter(CompletableFuture<Iterator<T>> initFut, Executor exec) {
        super(initFut, exec);
        this.initialized = initFut;
    }

    public IteratorToDataCursorAdapter(Iterator<T> source) {
        this(CompletableFuture.completedFuture(source), Runnable::run);
    }

    @Override
    public CompletableFuture<Void> onClose() {
        return CompletableFutures.nullCompletedFuture();
    }

    @Override
    public CompletableFuture<Void> onFirstPageReady() {
        return this.initialized.thenRun(() -> {});
    }

    @Override
    public CompletableFuture<Void> cancelAsync(AsyncDataCursor.CancellationReason reason) {
        if (reason == AsyncDataCursor.CancellationReason.TIMEOUT && !this.initialized.isDone()) {
            this.initialized.completeExceptionally(new QueryCancelledException("Query timeout"));
        }
        return CompletableFutures.nullCompletedFuture();
    }
}

