/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.tcp.ipfinder.s3;

import com.amazonaws.AmazonClientException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base32;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.spi.IgniteSpiConfiguration;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinderAdapter;
import org.apache.ignite.spi.discovery.tcp.ipfinder.s3.encrypt.EncryptionService;
import org.jetbrains.annotations.Nullable;

public class TcpDiscoveryS3IpFinder
extends TcpDiscoveryIpFinderAdapter {
    private static final String DELIM = "#";
    private static final byte[] ENTRY_CONTENT = new byte[]{1};
    @GridToStringExclude
    private final ObjectMetadata objMetadata = new ObjectMetadata();
    @LoggerResource
    private IgniteLogger log;
    @GridToStringExclude
    private AmazonS3 s3;
    private String bucketName;
    @Nullable
    private String bucketEndpoint;
    @Nullable
    private String sseAlg;
    @Nullable
    private String keyPrefix;
    @Nullable
    private EncryptionService encryptionSvc;
    @GridToStringExclude
    private final AtomicBoolean initGuard = new AtomicBoolean();
    @GridToStringExclude
    private final CountDownLatch initLatch = new CountDownLatch(1);
    private ClientConfiguration cfg;
    @GridToStringExclude
    private AWSCredentials cred;
    @GridToStringExclude
    private AWSCredentialsProvider credProvider;

    public TcpDiscoveryS3IpFinder() {
        this.setShared(true);
    }

    public Collection<InetSocketAddress> getRegisteredAddresses() throws IgniteSpiException {
        this.initClient();
        LinkedList<InetSocketAddress> addrs = new LinkedList<InetSocketAddress>();
        try {
            ObjectListing list = this.keyPrefix == null ? this.s3.listObjects(this.bucketName) : this.s3.listObjects(this.bucketName, this.keyPrefix);
            while (true) {
                for (S3ObjectSummary sum : list.getObjectSummaries()) {
                    InetSocketAddress addr = this.addr(sum);
                    if (addr == null) continue;
                    addrs.add(addr);
                }
                if (list.isTruncated()) {
                    list = this.s3.listNextBatchOfObjects(list);
                    continue;
                }
                break;
            }
        }
        catch (AmazonClientException e) {
            throw new IgniteSpiException("Failed to list objects in the bucket: " + this.bucketName, (Throwable)e);
        }
        return addrs;
    }

    private InetSocketAddress addr(S3ObjectSummary sum) {
        StringTokenizer st;
        String key;
        String addr = key = sum.getKey();
        if (this.keyPrefix != null) {
            addr = key.replaceFirst(Pattern.quote(this.keyPrefix), "");
        }
        if (this.encryptionSvc != null) {
            byte[] encBytes = new Base32().decode(addr.getBytes(StandardCharsets.UTF_8));
            byte[] decBytes = this.encryptionSvc.decrypt(encBytes);
            addr = new String(decBytes, StandardCharsets.UTF_8).replaceAll("=", "");
        }
        if ((st = new StringTokenizer(addr, DELIM)).countTokens() != 2) {
            U.error((IgniteLogger)this.log, (Object)("Failed to parse S3 entry due to invalid format: " + addr));
        } else {
            String addrStr = st.nextToken();
            String portStr = st.nextToken();
            int port = -1;
            try {
                port = Integer.parseInt(portStr);
            }
            catch (NumberFormatException e) {
                U.error((IgniteLogger)this.log, (Object)("Failed to parse port for S3 entry: " + addr), (Throwable)e);
            }
            if (port != -1) {
                try {
                    return new InetSocketAddress(addrStr, port);
                }
                catch (IllegalArgumentException e) {
                    U.error((IgniteLogger)this.log, (Object)("Failed to parse port for S3 entry: " + addr), (Throwable)e);
                }
            }
        }
        return null;
    }

    public void registerAddresses(Collection<InetSocketAddress> addrs) throws IgniteSpiException {
        assert (!F.isEmpty(addrs));
        this.initClient();
        for (InetSocketAddress addr : addrs) {
            String key = this.key(addr);
            try {
                this.s3.putObject(this.bucketName, key, (InputStream)new ByteArrayInputStream(ENTRY_CONTENT), this.objMetadata);
            }
            catch (AmazonClientException e) {
                throw new IgniteSpiException("Failed to put entry [bucketName=" + this.bucketName + ", entry=" + key + ']', (Throwable)e);
            }
        }
    }

    public void unregisterAddresses(Collection<InetSocketAddress> addrs) throws IgniteSpiException {
        assert (!F.isEmpty(addrs));
        this.initClient();
        for (InetSocketAddress addr : addrs) {
            String key = this.key(addr);
            try {
                this.s3.deleteObject(this.bucketName, key);
            }
            catch (AmazonClientException e) {
                throw new IgniteSpiException("Failed to delete entry [bucketName=" + this.bucketName + ", entry=" + key + ']', (Throwable)e);
            }
        }
    }

    private String key(InetSocketAddress addr) {
        assert (addr != null);
        SB sb = new SB();
        if (this.keyPrefix != null) {
            sb.a(this.keyPrefix);
        }
        String addrStr = addr.getAddress().getHostAddress();
        if (this.encryptionSvc != null) {
            String addrPort = new SB().a(addrStr).a(DELIM).a(addr.getPort()).toString();
            byte[] encBytes = this.encryptionSvc.encrypt(addrPort.getBytes(StandardCharsets.UTF_8));
            byte[] base32Bytes = new Base32().encode(encBytes);
            String encStr = new String(base32Bytes, StandardCharsets.UTF_8).replaceAll("=", "");
            sb.a(encStr);
        } else {
            sb.a(addrStr).a(DELIM).a(addr.getPort());
        }
        return sb.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initClient() throws IgniteSpiException {
        if (this.initGuard.compareAndSet(false, true)) {
            try {
                if (this.cred == null && this.credProvider == null) {
                    throw new IgniteSpiException("AWS credentials are not set.");
                }
                if (this.cfg == null) {
                    U.warn((IgniteLogger)this.log, (Object)"Amazon client configuration is not set (will use default).");
                }
                if (F.isEmpty((String)this.bucketName)) {
                    throw new IgniteSpiException("Bucket name is null or empty (provide bucket name and restart).");
                }
                this.objMetadata.setContentLength((long)ENTRY_CONTENT.length);
                if (!F.isEmpty((String)this.sseAlg)) {
                    this.objMetadata.setSSEAlgorithm(this.sseAlg);
                }
                this.s3 = this.createAmazonS3Client();
                if (this.s3.doesBucketExist(this.bucketName)) return;
                try {
                    this.s3.createBucket(this.bucketName);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Created S3 bucket: " + this.bucketName);
                    }
                    while (!this.s3.doesBucketExist(this.bucketName)) {
                        try {
                            U.sleep((long)200L);
                        }
                        catch (IgniteInterruptedCheckedException e) {
                            throw new IgniteSpiException("Thread has been interrupted.", (Throwable)e);
                            return;
                        }
                    }
                }
                catch (AmazonClientException e) {
                    if (this.s3.doesBucketExist(this.bucketName)) return;
                    this.s3 = null;
                    throw new IgniteSpiException("Failed to create bucket: " + this.bucketName, (Throwable)e);
                }
            }
            finally {
                this.initLatch.countDown();
            }
        }
        try {
            U.await((CountDownLatch)this.initLatch);
        }
        catch (IgniteInterruptedCheckedException e) {
            throw new IgniteSpiException("Thread has been interrupted.", (Throwable)e);
        }
        if (this.s3 != null) return;
        throw new IgniteSpiException("Ip finder has not been initialized properly.");
    }

    AmazonS3Client createAmazonS3Client() {
        AmazonS3Client cln;
        AmazonS3Client amazonS3Client = this.cfg != null ? (this.cred != null ? new AmazonS3Client(this.cred, this.cfg) : new AmazonS3Client(this.credProvider, this.cfg)) : (cln = this.cred != null ? new AmazonS3Client(this.cred) : new AmazonS3Client(this.credProvider));
        if (!F.isEmpty((String)this.bucketEndpoint)) {
            cln.setEndpoint(this.bucketEndpoint);
        }
        return cln;
    }

    @IgniteSpiConfiguration(optional=false)
    public TcpDiscoveryS3IpFinder setBucketName(String bucketName) {
        this.bucketName = bucketName;
        return this;
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpDiscoveryS3IpFinder setBucketEndpoint(String bucketEndpoint) {
        this.bucketEndpoint = bucketEndpoint;
        return this;
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpDiscoveryS3IpFinder setSSEAlgorithm(String sseAlg) {
        this.sseAlg = sseAlg;
        return this;
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpDiscoveryS3IpFinder setClientConfiguration(ClientConfiguration cfg) {
        this.cfg = cfg;
        return this;
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpDiscoveryS3IpFinder setEncryptionService(EncryptionService encryptionSvc) {
        this.encryptionSvc = encryptionSvc;
        return this;
    }

    @IgniteSpiConfiguration(optional=false)
    public TcpDiscoveryS3IpFinder setAwsCredentials(AWSCredentials cred) {
        this.cred = cred;
        return this;
    }

    @IgniteSpiConfiguration(optional=false)
    public TcpDiscoveryS3IpFinder setAwsCredentialsProvider(AWSCredentialsProvider credProvider) {
        this.credProvider = credProvider;
        return this;
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpDiscoveryS3IpFinder setKeyPrefix(String keyPrefix) {
        this.keyPrefix = keyPrefix;
        return this;
    }

    public TcpDiscoveryS3IpFinder setShared(boolean shared) {
        super.setShared(shared);
        return this;
    }

    public String toString() {
        return S.toString(TcpDiscoveryS3IpFinder.class, (Object)((Object)this), (String)"super", (Object)super.toString());
    }
}

