/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.tcp.ipfinder.s3.encrypt;

import java.security.Key;
import java.security.KeyPair;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.spi.discovery.tcp.ipfinder.s3.encrypt.EncryptionService;

public class AsymmetricKeyEncryptionService
implements EncryptionService {
    private Key publicKey;
    private Key privateKey;
    private Cipher encCipher;
    private Cipher decCipher;

    public void setKeyPair(KeyPair keyPair) {
        if (keyPair.getPublic() == null) {
            throw new IgniteException("Public key was not set / was set to null.");
        }
        if (keyPair.getPrivate() == null) {
            throw new IgniteException("Private key was not set / was set to null.");
        }
        this.publicKey = keyPair.getPublic();
        this.privateKey = keyPair.getPrivate();
    }

    @Override
    public void init() throws IgniteException {
        if (this.privateKey == null) {
            throw new IgniteException("Private key was not set / was set to null.");
        }
        if (this.publicKey == null) {
            throw new IgniteException("Public key was not set / was set to null.");
        }
        this.encCipher = IgniteUtils.createCipher((Key)this.privateKey, (int)1);
        this.decCipher = IgniteUtils.createCipher((Key)this.publicKey, (int)2);
    }

    @Override
    public byte[] encrypt(byte[] data) {
        if (data == null) {
            throw new IgniteException("Parameter data cannot be null");
        }
        if (this.encCipher == null) {
            throw new IgniteException("The init() method was not called.");
        }
        try {
            return this.encCipher.doFinal(data);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new IgniteException((Throwable)e);
        }
    }

    @Override
    public byte[] decrypt(byte[] data) {
        if (data == null) {
            throw new IgniteException("Parameter data cannot be null");
        }
        if (this.decCipher == null) {
            throw new IgniteException("The init() method was not called.");
        }
        try {
            return this.decCipher.doFinal(data);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new IgniteException((Throwable)e);
        }
    }

    public String toString() {
        return S.toString(AsymmetricKeyEncryptionService.class, (Object)this, (String)"super", (Object)super.toString());
    }
}

