/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.tcp.ipfinder.gce;

import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.InputStreamContent;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.Bucket;
import com.google.api.services.storage.model.Objects;
import com.google.api.services.storage.model.StorageObject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.spi.IgniteSpiConfiguration;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinderAdapter;

public class TcpDiscoveryGoogleStorageIpFinder
extends TcpDiscoveryIpFinderAdapter {
    private static final ByteArrayInputStream OBJECT_CONTENT = new ByteArrayInputStream(new byte[0]);
    @LoggerResource
    private IgniteLogger log;
    private String projectName;
    private String bucketName;
    private String srvcAccountP12FilePath;
    private String srvcAccountId;
    private Storage storage;
    private final AtomicBoolean initGuard = new AtomicBoolean();
    private final CountDownLatch initLatch = new CountDownLatch(1);

    public TcpDiscoveryGoogleStorageIpFinder() {
        this.setShared(true);
    }

    public Collection<InetSocketAddress> getRegisteredAddresses() throws IgniteSpiException {
        this.init();
        ArrayList<InetSocketAddress> addrs = new ArrayList<InetSocketAddress>();
        try {
            Objects objects;
            Storage.Objects.List listObjects = this.storage.objects().list(this.bucketName);
            while ((objects = (Objects)listObjects.execute()) != null && objects.getItems() != null) {
                for (StorageObject object : objects.getItems()) {
                    addrs.add(this.addrFromString(object.getName()));
                }
                listObjects.setPageToken(objects.getNextPageToken());
                if (null != objects.getNextPageToken()) continue;
                break;
            }
        }
        catch (Exception e) {
            throw new IgniteSpiException("Failed to get content from the bucket: " + this.bucketName, (Throwable)e);
        }
        return addrs;
    }

    public void registerAddresses(Collection<InetSocketAddress> addrs) throws IgniteSpiException {
        assert (!F.isEmpty(addrs));
        this.init();
        for (InetSocketAddress addr : addrs) {
            String key = this.keyFromAddr(addr);
            StorageObject object = new StorageObject();
            object.setBucket(this.bucketName);
            object.setName(key);
            InputStreamContent content = new InputStreamContent("application/octet-stream", (InputStream)OBJECT_CONTENT);
            content.setLength((long)OBJECT_CONTENT.available());
            try {
                Storage.Objects.Insert insertObject = this.storage.objects().insert(this.bucketName, object, (AbstractInputStreamContent)content);
                insertObject.execute();
            }
            catch (Exception e) {
                throw new IgniteSpiException("Failed to put entry [bucketName=" + this.bucketName + ", entry=" + key + ']', (Throwable)e);
            }
        }
    }

    public void unregisterAddresses(Collection<InetSocketAddress> addrs) throws IgniteSpiException {
        assert (!F.isEmpty(addrs));
        this.init();
        for (InetSocketAddress addr : addrs) {
            String key = this.keyFromAddr(addr);
            try {
                Storage.Objects.Delete deleteObject = this.storage.objects().delete(this.bucketName, key);
                deleteObject.execute();
            }
            catch (Exception e) {
                throw new IgniteSpiException("Failed to delete entry [bucketName=" + this.bucketName + ", entry=" + key + ']', (Throwable)e);
            }
        }
    }

    @IgniteSpiConfiguration(optional=false)
    public TcpDiscoveryGoogleStorageIpFinder setProjectName(String projectName) {
        this.projectName = projectName;
        return this;
    }

    @IgniteSpiConfiguration(optional=false)
    public TcpDiscoveryGoogleStorageIpFinder setBucketName(String bucketName) {
        this.bucketName = bucketName;
        return this;
    }

    @IgniteSpiConfiguration(optional=false)
    public TcpDiscoveryGoogleStorageIpFinder setServiceAccountP12FilePath(String p12FileName) {
        this.srvcAccountP12FilePath = p12FileName;
        return this;
    }

    @IgniteSpiConfiguration(optional=false)
    public TcpDiscoveryGoogleStorageIpFinder setServiceAccountId(String id) {
        this.srvcAccountId = id;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void init() throws IgniteSpiException {
        if (this.initGuard.compareAndSet(false, true)) {
            if (this.srvcAccountId == null || this.srvcAccountP12FilePath == null || this.projectName == null || this.bucketName == null) {
                throw new IgniteSpiException("One or more of the required parameters is not set [serviceAccountId=" + this.srvcAccountId + ", serviceAccountP12FilePath=" + this.srvcAccountP12FilePath + ", projectName=" + this.projectName + ", bucketName=" + this.bucketName + "]");
            }
            try {
                GoogleCredential cred;
                NetHttpTransport httpTransport;
                try {
                    httpTransport = GoogleNetHttpTransport.newTrustedTransport();
                }
                catch (IOException | GeneralSecurityException e) {
                    throw new IgniteSpiException((Throwable)e);
                }
                try {
                    cred = new GoogleCredential.Builder().setTransport((HttpTransport)httpTransport).setJsonFactory((JsonFactory)JacksonFactory.getDefaultInstance()).setServiceAccountId(this.srvcAccountId).setServiceAccountPrivateKeyFromP12File(new File(this.srvcAccountP12FilePath)).setServiceAccountScopes(Collections.singleton("https://www.googleapis.com/auth/devstorage.full_control")).build();
                }
                catch (Exception e) {
                    throw new IgniteSpiException("Failed to authenticate on Google Cloud Platform", (Throwable)e);
                }
                try {
                    this.storage = new Storage.Builder((HttpTransport)httpTransport, (JsonFactory)JacksonFactory.getDefaultInstance(), (HttpRequestInitializer)cred).setApplicationName(this.projectName).build();
                }
                catch (Exception e) {
                    throw new IgniteSpiException("Failed to open a storage for given project name: " + this.projectName, (Throwable)e);
                }
                boolean createBucket = false;
                try {
                    Storage.Buckets.Get getBucket = this.storage.buckets().get(this.bucketName);
                    getBucket.setProjection("full");
                    getBucket.execute();
                }
                catch (GoogleJsonResponseException e) {
                    if (e.getStatusCode() != 404) throw new IgniteSpiException("Failed to open the bucket: " + this.bucketName, (Throwable)e);
                    U.warn((IgniteLogger)this.log, (Object)("Bucket doesn't exist, will create it [bucketName=" + this.bucketName + "]"));
                    createBucket = true;
                }
                catch (Exception e) {
                    throw new IgniteSpiException("Failed to open the bucket: " + this.bucketName, (Throwable)e);
                }
                if (!createBucket) return;
                Bucket newBucket = new Bucket();
                newBucket.setName(this.bucketName);
                try {
                    Storage.Buckets.Insert insertBucket = this.storage.buckets().insert(this.projectName, newBucket);
                    insertBucket.setProjection("full");
                    insertBucket.setPredefinedDefaultObjectAcl("projectPrivate");
                    insertBucket.execute();
                    return;
                }
                catch (Exception e) {
                    throw new IgniteSpiException("Failed to create the bucket: " + this.bucketName, (Throwable)e);
                }
            }
            finally {
                this.initLatch.countDown();
            }
        }
        try {
            U.await((CountDownLatch)this.initLatch);
        }
        catch (IgniteInterruptedCheckedException e) {
            throw new IgniteSpiException("Thread has been interrupted.", (Throwable)e);
        }
        if (this.storage != null) return;
        throw new IgniteSpiException("IpFinder has not been initialized properly");
    }

    private String keyFromAddr(InetSocketAddress addr) {
        return addr.getAddress().getHostAddress() + "#" + addr.getPort();
    }

    private InetSocketAddress addrFromString(String key) throws IgniteSpiException {
        int port;
        String[] res = key.split("#");
        if (res.length != 2) {
            throw new IgniteSpiException("Invalid address string: " + key);
        }
        try {
            port = Integer.parseInt(res[1]);
        }
        catch (NumberFormatException ignored) {
            throw new IgniteSpiException("Invalid port number: " + res[1]);
        }
        return new InetSocketAddress(res[0], port);
    }

    private void removeBucket(String bucketName) {
        this.init();
        try {
            Storage.Buckets.Delete deleteBucket = this.storage.buckets().delete(bucketName);
            deleteBucket.execute();
        }
        catch (Exception e) {
            throw new IgniteSpiException("Failed to remove the bucket: " + bucketName, (Throwable)e);
        }
    }

    public TcpDiscoveryGoogleStorageIpFinder setShared(boolean shared) {
        super.setShared(shared);
        return this;
    }

    public String toString() {
        return S.toString(TcpDiscoveryGoogleStorageIpFinder.class, (Object)((Object)this));
    }
}

