/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.performancestatistics.util;

import com.fasterxml.jackson.core.io.CharTypes;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.PrintStream;

public class Utils {
    public static final ObjectMapper MAPPER = new ObjectMapper();
    private static final char[] HC = "0123456789ABCDEF".toCharArray();

    public static ObjectNode createObjectIfAbsent(String val, ObjectNode json) {
        ObjectNode node = (ObjectNode)json.get(val);
        if (node == null) {
            node = MAPPER.createObjectNode();
            json.set(val, (JsonNode)node);
        }
        return node;
    }

    public static ArrayNode createArrayIfAbsent(String val, ObjectNode json) {
        ArrayNode node = (ArrayNode)json.get(val);
        if (node == null) {
            node = MAPPER.createArrayNode();
            json.set(val, (JsonNode)node);
        }
        return node;
    }

    public static void printEscaped(PrintStream ps, String str) {
        int[] escCodes = CharTypes.get7BitOutputEscapes();
        int escLen = escCodes.length;
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c >= escLen || escCodes[c] == 0) {
                ps.print(c);
                continue;
            }
            ps.print('\\');
            int escCode = escCodes[c];
            if (escCode < 0) {
                ps.print('u');
                ps.print('0');
                ps.print('0');
                char val = c;
                ps.print(HC[val >> 4]);
                ps.print(HC[val & 0xF]);
                continue;
            }
            ps.print((char)escCode);
        }
    }
}

