/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.cache;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import org.apache.ignite.internal.processors.cache.query.GridCacheSqlIndexMetadata;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;

public class VisorCacheSqlIndexMetadata
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private String name;
    private List<String> fields;
    private List<String> descendings;
    private boolean unique;

    public VisorCacheSqlIndexMetadata() {
    }

    public VisorCacheSqlIndexMetadata(GridCacheSqlIndexMetadata meta) {
        this.name = meta.name();
        this.fields = VisorCacheSqlIndexMetadata.toList(meta.fields());
        this.descendings = VisorCacheSqlIndexMetadata.toList(meta.descendings());
        this.unique = meta.unique();
    }

    public String getName() {
        return this.name;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public List<String> getDescendings() {
        return this.descendings;
    }

    public boolean isUnique() {
        return this.unique;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeString(out, this.name);
        U.writeCollection(out, this.fields);
        U.writeCollection(out, this.descendings);
        out.writeBoolean(this.unique);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = U.readString(in);
        this.fields = U.readList(in);
        this.descendings = U.readList(in);
        this.unique = in.readBoolean();
    }

    public String toString() {
        return S.toString(VisorCacheSqlIndexMetadata.class, this);
    }
}

