/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.metric;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.metric.GridMetricManager;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.processors.task.GridVisorManagementTask;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.apache.ignite.internal.visor.metric.VisorMetricTaskArg;
import org.apache.ignite.spi.metric.BooleanMetric;
import org.apache.ignite.spi.metric.DoubleMetric;
import org.apache.ignite.spi.metric.IntMetric;
import org.apache.ignite.spi.metric.LongMetric;
import org.apache.ignite.spi.metric.Metric;
import org.apache.ignite.spi.metric.ObjectMetric;
import org.apache.ignite.spi.metric.ReadOnlyMetricRegistry;
import org.apache.ignite.spi.metric.jmx.MetricRegistryMBean;
import org.jetbrains.annotations.Nullable;

@GridInternal
@GridVisorManagementTask
public class VisorMetricTask
extends VisorOneNodeTask<VisorMetricTaskArg, Map<String, ?>> {
    private static final long serialVersionUID = 0L;

    @Override
    protected VisorJob<VisorMetricTaskArg, Map<String, ?>> job(VisorMetricTaskArg arg) {
        return new VisorMetricJob(arg, false);
    }

    private static class VisorMetricJob
    extends VisorJob<VisorMetricTaskArg, Map<String, ?>> {
        private static final long serialVersionUID = 0L;

        protected VisorMetricJob(@Nullable VisorMetricTaskArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected Map<String, ?> run(@Nullable VisorMetricTaskArg arg) throws IgniteException {
            String name = arg.name();
            GridMetricManager mmgr = this.ignite.context().metric();
            for (ReadOnlyMetricRegistry mreg : mmgr) {
                String mregName = mreg.name();
                if (mregName.equals(name)) {
                    HashMap res = new HashMap();
                    mreg.forEach(metric -> res.put(metric.name(), this.valueOf((Metric)metric)));
                    return res;
                }
                String mregPrefix = mregName + ".";
                if (!name.startsWith(mregPrefix)) continue;
                if (mregPrefix.length() == name.length()) {
                    return null;
                }
                String metricName = name.substring(mregPrefix.length());
                Object metric2 = mreg.findMetric(metricName);
                if (metric2 != null) {
                    return Collections.singletonMap(name, this.valueOf((Metric)metric2));
                }
                Long val = MetricRegistryMBean.searchHistogram(metricName, mreg);
                if (val == null) continue;
                return Collections.singletonMap(name, val);
            }
            return null;
        }

        private Object valueOf(Metric metric) {
            if (metric instanceof BooleanMetric) {
                return ((BooleanMetric)metric).value();
            }
            if (metric instanceof DoubleMetric) {
                return ((DoubleMetric)metric).value();
            }
            if (metric instanceof IntMetric) {
                return ((IntMetric)metric).value();
            }
            if (metric instanceof LongMetric) {
                return ((LongMetric)metric).value();
            }
            if (metric instanceof ObjectMetric) {
                return metric.getAsString();
            }
            throw new IllegalArgumentException("Unknown metric class [class=" + metric.getClass() + ']');
        }
    }
}

