/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.node;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import org.apache.ignite.configuration.CheckpointWriteOrder;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.WALMode;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.apache.ignite.internal.visor.node.VisorDataRegionConfiguration;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;

public class VisorDataStorageConfiguration
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private long sysRegionInitSize;
    private long sysRegionMaxSize;
    private int pageSize;
    private int concLvl;
    private VisorDataRegionConfiguration dfltDataRegCfg;
    private List<VisorDataRegionConfiguration> dataRegCfgs;
    private String storagePath;
    private long checkpointFreq;
    private long lockWaitTime;
    private int checkpointThreads;
    private CheckpointWriteOrder checkpointWriteOrder;
    private int walHistSize;
    private int walSegments;
    private int walSegmentSize;
    private String walPath;
    private String walArchivePath;
    private boolean metricsEnabled;
    private WALMode walMode;
    private int walTlbSize;
    private long walFlushFreq;
    private long walFsyncDelay;
    private int walRecordIterBuffSize;
    private boolean alwaysWriteFullPages;
    private String fileIOFactory;
    private int metricsSubIntervalCount;
    private long metricsRateTimeInterval;
    private long walAutoArchiveAfterInactivity;
    private boolean writeThrottlingEnabled;
    private int walBufSize;
    private boolean walCompactionEnabled;

    public VisorDataStorageConfiguration() {
    }

    public VisorDataStorageConfiguration(DataStorageConfiguration cfg) {
        assert (cfg != null);
        this.sysRegionInitSize = cfg.getSystemRegionInitialSize();
        this.sysRegionMaxSize = cfg.getSystemRegionMaxSize();
        this.pageSize = cfg.getPageSize();
        this.concLvl = cfg.getConcurrencyLevel();
        DataRegionConfiguration dfltRegion = cfg.getDefaultDataRegionConfiguration();
        if (dfltRegion != null) {
            this.dfltDataRegCfg = new VisorDataRegionConfiguration(dfltRegion);
        }
        this.dataRegCfgs = VisorDataRegionConfiguration.from(cfg.getDataRegionConfigurations());
        this.storagePath = cfg.getStoragePath();
        this.checkpointFreq = cfg.getCheckpointFrequency();
        this.lockWaitTime = cfg.getLockWaitTime();
        this.checkpointThreads = cfg.getCheckpointThreads();
        this.checkpointWriteOrder = cfg.getCheckpointWriteOrder();
        this.walHistSize = cfg.getWalHistorySize();
        this.walSegments = cfg.getWalSegments();
        this.walSegmentSize = cfg.getWalSegmentSize();
        this.walPath = cfg.getWalPath();
        this.walArchivePath = cfg.getWalArchivePath();
        this.metricsEnabled = cfg.isMetricsEnabled();
        this.walMode = cfg.getWalMode();
        this.walTlbSize = cfg.getWalThreadLocalBufferSize();
        this.walBufSize = cfg.getWalBufferSize();
        this.walFlushFreq = cfg.getWalFlushFrequency();
        this.walFsyncDelay = cfg.getWalFsyncDelayNanos();
        this.walRecordIterBuffSize = cfg.getWalRecordIteratorBufferSize();
        this.alwaysWriteFullPages = cfg.isAlwaysWriteFullPages();
        this.fileIOFactory = VisorTaskUtils.compactClass(cfg.getFileIOFactory());
        this.metricsSubIntervalCount = cfg.getMetricsSubIntervalCount();
        this.metricsRateTimeInterval = cfg.getMetricsRateTimeInterval();
        this.walAutoArchiveAfterInactivity = cfg.getWalAutoArchiveAfterInactivity();
        this.writeThrottlingEnabled = cfg.isWriteThrottlingEnabled();
        this.walCompactionEnabled = cfg.isWalCompactionEnabled();
    }

    public long getSystemRegionInitialSize() {
        return this.sysRegionInitSize;
    }

    public long getSystemRegionMaxSize() {
        return this.sysRegionMaxSize;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getConcurrencyLevel() {
        return this.concLvl;
    }

    public VisorDataRegionConfiguration getDefaultDataRegionConfiguration() {
        return this.dfltDataRegCfg;
    }

    public List<VisorDataRegionConfiguration> getDataRegionConfigurations() {
        return this.dataRegCfgs;
    }

    public String getStoragePath() {
        return this.storagePath;
    }

    public long getCheckpointFrequency() {
        return this.checkpointFreq;
    }

    public int getCheckpointThreads() {
        return this.checkpointThreads;
    }

    public CheckpointWriteOrder getCheckpointWriteOrder() {
        return this.checkpointWriteOrder;
    }

    public long getLockWaitTime() {
        return this.lockWaitTime;
    }

    public int getWalHistorySize() {
        return this.walHistSize;
    }

    public int getWalSegments() {
        return this.walSegments;
    }

    public int getWalSegmentSize() {
        return this.walSegmentSize;
    }

    public String getWalPath() {
        return this.walPath;
    }

    public String getWalArchivePath() {
        return this.walArchivePath;
    }

    public boolean isMetricsEnabled() {
        return this.metricsEnabled;
    }

    public long getMetricsRateTimeInterval() {
        return this.metricsRateTimeInterval;
    }

    public int getMetricsSubIntervalCount() {
        return this.metricsSubIntervalCount;
    }

    public WALMode getWalMode() {
        return this.walMode;
    }

    public int getWalThreadLocalBufferSize() {
        return this.walTlbSize;
    }

    public long getWalFlushFrequency() {
        return this.walFlushFreq;
    }

    public long getWalFsyncDelayNanos() {
        return this.walFsyncDelay;
    }

    public int getWalRecordIteratorBufferSize() {
        return this.walRecordIterBuffSize;
    }

    public boolean isAlwaysWriteFullPages() {
        return this.alwaysWriteFullPages;
    }

    public String getFileIOFactory() {
        return this.fileIOFactory;
    }

    public long getWalAutoArchiveAfterInactivity() {
        return this.walAutoArchiveAfterInactivity;
    }

    public boolean isWriteThrottlingEnabled() {
        return this.writeThrottlingEnabled;
    }

    public int getWalBufferSize() {
        return this.walBufSize;
    }

    public boolean isWalCompactionEnabled() {
        return this.walCompactionEnabled;
    }

    @Override
    public byte getProtocolVersion() {
        return 2;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeLong(this.sysRegionInitSize);
        out.writeLong(this.sysRegionMaxSize);
        out.writeInt(this.pageSize);
        out.writeInt(this.concLvl);
        out.writeObject(this.dfltDataRegCfg);
        U.writeCollection(out, this.dataRegCfgs);
        U.writeString(out, this.storagePath);
        out.writeLong(this.checkpointFreq);
        out.writeLong(this.lockWaitTime);
        out.writeLong(0L);
        out.writeInt(this.checkpointThreads);
        U.writeEnum(out, this.checkpointWriteOrder);
        out.writeInt(this.walHistSize);
        out.writeInt(this.walSegments);
        out.writeInt(this.walSegmentSize);
        U.writeString(out, this.walPath);
        U.writeString(out, this.walArchivePath);
        out.writeBoolean(this.metricsEnabled);
        U.writeEnum(out, this.walMode);
        out.writeInt(this.walTlbSize);
        out.writeLong(this.walFlushFreq);
        out.writeLong(this.walFsyncDelay);
        out.writeInt(this.walRecordIterBuffSize);
        out.writeBoolean(this.alwaysWriteFullPages);
        U.writeString(out, this.fileIOFactory);
        out.writeInt(this.metricsSubIntervalCount);
        out.writeLong(this.metricsRateTimeInterval);
        out.writeLong(this.walAutoArchiveAfterInactivity);
        out.writeBoolean(this.writeThrottlingEnabled);
        out.writeInt(this.walBufSize);
        out.writeBoolean(this.walCompactionEnabled);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.sysRegionInitSize = in.readLong();
        this.sysRegionMaxSize = in.readLong();
        this.pageSize = in.readInt();
        this.concLvl = in.readInt();
        this.dfltDataRegCfg = (VisorDataRegionConfiguration)in.readObject();
        this.dataRegCfgs = U.readList(in);
        this.storagePath = U.readString(in);
        this.checkpointFreq = in.readLong();
        this.lockWaitTime = in.readLong();
        in.readLong();
        this.checkpointThreads = in.readInt();
        this.checkpointWriteOrder = CheckpointWriteOrder.fromOrdinal(in.readByte());
        this.walHistSize = in.readInt();
        this.walSegments = in.readInt();
        this.walSegmentSize = in.readInt();
        this.walPath = U.readString(in);
        this.walArchivePath = U.readString(in);
        this.metricsEnabled = in.readBoolean();
        this.walMode = WALMode.fromOrdinal(in.readByte());
        this.walTlbSize = in.readInt();
        this.walFlushFreq = in.readLong();
        this.walFsyncDelay = in.readLong();
        this.walRecordIterBuffSize = in.readInt();
        this.alwaysWriteFullPages = in.readBoolean();
        this.fileIOFactory = U.readString(in);
        this.metricsSubIntervalCount = in.readInt();
        this.metricsRateTimeInterval = in.readLong();
        this.walAutoArchiveAfterInactivity = in.readLong();
        this.writeThrottlingEnabled = in.readBoolean();
        if (protoVer > 1) {
            this.walBufSize = in.readInt();
            this.walCompactionEnabled = in.readBoolean();
        }
    }

    public String toString() {
        return S.toString(VisorDataStorageConfiguration.class, this);
    }
}

