/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.node;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.List;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.jetbrains.annotations.Nullable;

public class VisorPeerToPeerConfiguration
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private boolean p2pEnabled;
    private int p2pMissedResCacheSize;
    private List<String> p2pLocClsPathExcl;

    public VisorPeerToPeerConfiguration() {
    }

    public VisorPeerToPeerConfiguration(IgniteConfiguration c) {
        this.p2pEnabled = c.isPeerClassLoadingEnabled();
        this.p2pMissedResCacheSize = c.getPeerClassLoadingMissedResourcesCacheSize();
        this.p2pLocClsPathExcl = Arrays.asList(c.getPeerClassLoadingLocalClassPathExclude());
    }

    public boolean isPeerClassLoadingEnabled() {
        return this.p2pEnabled;
    }

    public int getPeerClassLoadingMissedResourcesCacheSize() {
        return this.p2pMissedResCacheSize;
    }

    @Nullable
    public List<String> getPeerClassLoadingLocalClassPathExclude() {
        return this.p2pLocClsPathExcl;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeBoolean(this.p2pEnabled);
        out.writeInt(this.p2pMissedResCacheSize);
        U.writeCollection(out, this.p2pLocClsPathExcl);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.p2pEnabled = in.readBoolean();
        this.p2pMissedResCacheSize = in.readInt();
        this.p2pLocClsPathExcl = U.readList(in);
    }

    public String toString() {
        return S.toString(VisorPeerToPeerConfiguration.class, this);
    }
}

