/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.query;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;

public class VisorQueryField
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private String schemaName;
    private String typeName;
    private String fieldName;
    private String fieldTypeName;

    public VisorQueryField() {
    }

    public VisorQueryField(String schemaName, String typeName, String fieldName, String fieldTypeName) {
        this.schemaName = schemaName;
        this.typeName = typeName;
        this.fieldName = fieldName;
        this.fieldTypeName = fieldTypeName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getFieldTypeName() {
        return this.fieldTypeName;
    }

    public String getFullName(boolean schema) {
        if (!F.isEmpty(this.typeName)) {
            if (schema && !F.isEmpty(this.schemaName)) {
                return this.schemaName + "." + this.typeName + "." + this.fieldName;
            }
            return this.typeName + "." + this.fieldName;
        }
        return this.fieldName;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeString(out, this.schemaName);
        U.writeString(out, this.typeName);
        U.writeString(out, this.fieldName);
        U.writeString(out, this.fieldTypeName);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.schemaName = U.readString(in);
        this.typeName = U.readString(in);
        this.fieldName = U.readString(in);
        this.fieldTypeName = U.readString(in);
    }

    public String toString() {
        return S.toString(VisorQueryField.class, this);
    }
}

