<!--
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to you under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
-->
<div align="center">

# Apache Baremaps (Incubating)

[![PRs Welcome](https://img.shields.io/badge/PRs-welcome-brightgreen.svg?style=flat&logo=github&color=2370ff&labelColor=454545)](http://makeapullrequest.com)
![Build Passing](https://github.com/baremaps/baremaps/actions/workflows/build.yml/badge.svg)
[![Vulnerabilities](https://sonarcloud.io/api/project_badges/measure?project=apache_baremaps&metric=vulnerabilities)](https://sonarcloud.io/project/overview?id=apache_baremaps)
[![Mailing List](https://img.shields.io/badge/Apache-dev_mailing_list-success.svg?logo=apache)](https://lists.apache.org/list.html?dev@baremaps.apache.org)

</div>

**Apache Baremaps** is a toolkit and a set of infrastructure components for creating, publishing, and operating online maps. It provides a data pipeline enabling developers to build maps with different data sources with live reload capabilities. It provides other services commonly used in online maps, such as location search and IP to location.

## 🔥 Live Demo

[Live Demo](https://baremaps.apache.org/map/)

## 📖 How do I use Apache Baremaps?

You can find a [getting started](https://baremaps.apache.org/documentation/getting-started/) and [additional examples] on the project's [website](https://baremaps.apache.org/).

## 👩‍💻 How do I contribute?

There are many places where you can contribute to Apache Baremaps and your contributions are more than welcome.

The [developer manual](https://baremaps.apache.org/documentation/additional-examples/) provides a good starting point on how to build and run the project from source.

You can contribute in the following ways:
- Improve the code: Report [a bug or submit a feature request](https://github.com/apache/incubator-baremaps/issues), or [submit a pull request](https://github.com/apache/incubator-baremaps/pulls) in the [incubator-baremaps](https://github.com/apache/incubator-baremaps/) repository.
- Improve the documentation: Report [documentation issue](https://github.com/apache/incubator-baremaps-site/issues) or [submit a pull request](https://github.com/apache/incubator-baremaps-site/pulls) in the [incubator-baremaps-site](https://github.com/apache/incubator-baremaps-site/) repository.
- [Join the mailing list](https://lists.apache.org/list.html?dev@baremaps.apache.org): Initiate or participate in project discussions on the mailing list.
- Write a post: Write a post to share your use cases and experiences with Apache Baremaps.

Finally, check out [CONTRIBUTING](CONTRIBUTING.md) and [CODE_OF_CONDUCT](CODE_OF_CONDUCT.md).

## 📄 License

This project is licensed under Apache License 2.0 - see the [LICENSE](LICENSE) file for details.
