/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.connection;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import org.apache.polaris.core.PolarisDiagnostics;
import org.apache.polaris.core.admin.model.ConnectionConfigInfo;
import org.apache.polaris.core.admin.model.HadoopConnectionConfigInfo;
import org.apache.polaris.core.admin.model.IcebergRestConnectionConfigInfo;
import org.apache.polaris.core.connection.AuthenticationParametersDpo;
import org.apache.polaris.core.connection.hadoop.HadoopConnectionConfigInfoDpo;
import org.apache.polaris.core.connection.iceberg.IcebergCatalogPropertiesProvider;
import org.apache.polaris.core.connection.iceberg.IcebergRestConnectionConfigInfoDpo;
import org.apache.polaris.core.secrets.UserSecretReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="connectionTypeCode")
@JsonSubTypes(value={@JsonSubTypes.Type(value=IcebergRestConnectionConfigInfoDpo.class, name="1"), @JsonSubTypes.Type(value=HadoopConnectionConfigInfoDpo.class, name="2")})
public abstract class ConnectionConfigInfoDpo
implements IcebergCatalogPropertiesProvider {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionConfigInfoDpo.class);
    private final int connectionTypeCode;
    private final String uri;
    private final AuthenticationParametersDpo authenticationParameters;
    private static final ObjectMapper DEFAULT_MAPPER = new ObjectMapper();

    public ConnectionConfigInfoDpo(@JsonProperty(value="connectionTypeCode", required=true) int connectionTypeCode, @JsonProperty(value="uri", required=true) @Nonnull String uri, @JsonProperty(value="authenticationParameters", required=true) @Nonnull AuthenticationParametersDpo authenticationParameters) {
        this(connectionTypeCode, uri, authenticationParameters, true);
    }

    protected ConnectionConfigInfoDpo(int connectionTypeCode, @Nonnull String uri, @Nonnull AuthenticationParametersDpo authenticationParameters, boolean validateUri) {
        this.connectionTypeCode = connectionTypeCode;
        this.uri = uri;
        this.authenticationParameters = authenticationParameters;
        if (validateUri) {
            this.validateUri(uri);
        }
    }

    public int getConnectionTypeCode() {
        return this.connectionTypeCode;
    }

    public String getUri() {
        return this.uri;
    }

    public AuthenticationParametersDpo getAuthenticationParameters() {
        return this.authenticationParameters;
    }

    public String serialize() {
        try {
            return DEFAULT_MAPPER.writeValueAsString((Object)this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public static ConnectionConfigInfoDpo deserialize(@Nonnull PolarisDiagnostics diagnostics, @Nonnull String jsonStr) {
        try {
            return (ConnectionConfigInfoDpo)DEFAULT_MAPPER.readValue(jsonStr, ConnectionConfigInfoDpo.class);
        }
        catch (JsonProcessingException exception) {
            diagnostics.fail("fail_to_deserialize_connection_configuration", exception, "jsonStr={}", jsonStr);
            return null;
        }
    }

    protected void validateUri(String uri) {
        try {
            URI uriObj = URI.create(uri);
            URL uRL = uriObj.toURL();
        }
        catch (IllegalArgumentException | MalformedURLException e) {
            throw new IllegalArgumentException("Invalid remote URI: " + uri, e);
        }
    }

    public static ConnectionConfigInfoDpo fromConnectionConfigInfoModelWithSecrets(ConnectionConfigInfo connectionConfigurationModel, Map<String, UserSecretReference> secretReferences) {
        ConnectionConfigInfoDpo config = null;
        switch (connectionConfigurationModel.getConnectionType()) {
            case ICEBERG_REST: {
                IcebergRestConnectionConfigInfo icebergRestConfigModel = (IcebergRestConnectionConfigInfo)connectionConfigurationModel;
                AuthenticationParametersDpo authenticationParameters = AuthenticationParametersDpo.fromAuthenticationParametersModelWithSecrets(icebergRestConfigModel.getAuthenticationParameters(), secretReferences);
                config = new IcebergRestConnectionConfigInfoDpo(icebergRestConfigModel.getUri(), authenticationParameters, icebergRestConfigModel.getRemoteCatalogName());
                break;
            }
            case HADOOP: {
                HadoopConnectionConfigInfo hadoopConfigModel = (HadoopConnectionConfigInfo)connectionConfigurationModel;
                AuthenticationParametersDpo authenticationParameters = AuthenticationParametersDpo.fromAuthenticationParametersModelWithSecrets(hadoopConfigModel.getAuthenticationParameters(), secretReferences);
                config = new HadoopConnectionConfigInfoDpo(hadoopConfigModel.getUri(), authenticationParameters, hadoopConfigModel.getWarehouse());
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported connection type: " + String.valueOf(connectionConfigurationModel.getConnectionType()));
            }
        }
        return config;
    }

    public abstract ConnectionConfigInfo asConnectionConfigInfoModel();

    static {
        DEFAULT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        DEFAULT_MAPPER.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }
}

