#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
#

# coding: utf-8

"""
    Apache Polaris and Apache Iceberg REST Catalog API

    Defines the specification for the Polaris Catalog API, which encompasses both the Iceberg REST Catalog API and Polaris-native API.

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import unittest

from polaris.catalog.api.policy_api import PolicyAPI


class TestPolicyAPI(unittest.TestCase):
    """PolicyAPI unit test stubs"""

    def setUp(self) -> None:
        self.api = PolicyAPI()

    def tearDown(self) -> None:
        pass

    def test_attach_policy(self) -> None:
        """Test case for attach_policy

        Create a mapping between a policy and a resource entity
        """
        pass

    def test_create_policy(self) -> None:
        """Test case for create_policy

        Create a policy in the given namespace
        """
        pass

    def test_detach_policy(self) -> None:
        """Test case for detach_policy

        Remove a mapping between a policy and a target entity
        """
        pass

    def test_drop_policy(self) -> None:
        """Test case for drop_policy

        Drop a policy from the catalog
        """
        pass

    def test_get_applicable_policies(self) -> None:
        """Test case for get_applicable_policies

        Get Applicable policies for catalog, namespace, table, or views
        """
        pass

    def test_list_policies(self) -> None:
        """Test case for list_policies

        List all policy identifiers underneath a given namespace
        """
        pass

    def test_load_policy(self) -> None:
        """Test case for load_policy

        Load a policy
        """
        pass

    def test_update_policy(self) -> None:
        """Test case for update_policy

        Update a policy
        """
        pass


if __name__ == '__main__':
    unittest.main()
