/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.client.log;

import com.alipay.sofa.common.log.LoggerSpaceManager;
import java.io.File;
import org.slf4j.Logger;

public class LoggerFactory {
    private static final String LOG_SPACE_PROPERTY = "registry.client.log.space";
    private static final String LOG_PATH = "logging.path";
    private static final String LOG_PATH_DEFAULT = System.getProperty("user.home") + File.separator + "logs";
    private static final String CLIENT_LOG_LEVEL = "com.alipay.sofa.registry.client.log.level";
    private static final String CLIENT_LOG_LEVEL_DEFAULT = "INFO";
    private static final String CLIENT_LOG_ENCODE = "com.alipay.sofa.registry.client.log.encode";
    private static final String CLIENT_LOG_ENCODE_DEFAULT = "UTF-8";
    private static String logSpace = "com.alipay.sofa.registry.client";

    static String getLogSpace() {
        String sysLogSpace = System.getProperty(LOG_SPACE_PROPERTY);
        return null != sysLogSpace && !sysLogSpace.isEmpty() ? sysLogSpace : logSpace;
    }

    public static Logger getLogger(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return LoggerFactory.getLogger(clazz.getCanonicalName());
    }

    public static Logger getLogger(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        return LoggerSpaceManager.getLoggerBySpace((String)name, (String)logSpace);
    }

    static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    static {
        logSpace = LoggerFactory.getLogSpace();
        String logPath = System.getProperty(LOG_PATH);
        String logLevel = System.getProperty(CLIENT_LOG_LEVEL);
        String logEncode = System.getProperty(CLIENT_LOG_ENCODE);
        if (LoggerFactory.isBlank(logPath)) {
            System.setProperty(LOG_PATH, LOG_PATH_DEFAULT);
        }
        if (LoggerFactory.isBlank(logLevel)) {
            System.setProperty(CLIENT_LOG_LEVEL, CLIENT_LOG_LEVEL_DEFAULT);
        }
        if (LoggerFactory.isBlank(logEncode)) {
            System.setProperty(CLIENT_LOG_ENCODE, CLIENT_LOG_ENCODE_DEFAULT);
        }
    }
}

