/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.client.task;

import com.alipay.sofa.registry.client.api.RegistryClientConfig;
import com.alipay.sofa.registry.client.log.LoggerFactory;
import com.alipay.sofa.registry.client.provider.DefaultSubscriber;
import com.alipay.sofa.registry.client.provider.RegisterCache;
import com.alipay.sofa.registry.client.remoting.Client;
import com.alipay.sofa.registry.client.task.ObserverHandler;
import com.alipay.sofa.registry.core.model.SyncConfigRequest;
import com.alipay.sofa.registry.core.model.SyncConfigResponse;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;

public class SyncConfigThread
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncConfigThread.class);
    private Client client;
    private RegisterCache registerCache;
    private RegistryClientConfig config;
    private ObserverHandler observerHandler;

    public SyncConfigThread(Client client, RegisterCache registerCache, RegistryClientConfig config, ObserverHandler observerHandler) {
        super("SyncConfigThread");
        this.setDaemon(true);
        this.client = client;
        this.registerCache = registerCache;
        this.config = config;
        this.observerHandler = observerHandler;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        retryInterval = this.config.getSyncConfigRetryInterval();
        while (true) {
            try {
                block5: while (true) {
                    Thread.sleep(retryInterval);
                    if (!this.client.isConnected()) continue;
                    request = new SyncConfigRequest();
                    request.setDataCenter(this.config.getDataCenter());
                    request.setZone(this.config.getZone());
                    result = this.client.invokeSync(request);
                    if (!(result instanceof SyncConfigResponse)) {
                        SyncConfigThread.LOGGER.warn("[syncConfig] unknown response type, {}", result);
                        continue;
                    }
                    response = (SyncConfigResponse)result;
                    if (!response.isSuccess()) {
                        SyncConfigThread.LOGGER.warn("[syncConfig] request failed, {}", (Object)response);
                        continue;
                    }
                    interval = response.getRetryInterval();
                    retryInterval = Math.max(retryInterval, interval);
                    availableSegments = response.getAvailableSegments();
                    allSubscribers = this.registerCache.getAllSubscribers();
                    var8_9 = allSubscribers.iterator();
                    while (true) {
                        if (var8_9.hasNext()) ** break;
                        continue block5;
                        subscriber = var8_9.next();
                        try {
                            if (!(subscriber instanceof DefaultSubscriber)) continue;
                            defaultSubscriber = (DefaultSubscriber)subscriber;
                            if (!defaultSubscriber.isInited()) {
                                SyncConfigThread.LOGGER.info("[syncConfig] DefaultSubscriber not init, {}", (Object)defaultSubscriber.getRegistId());
                                continue;
                            }
                            nowAvailableSegments = defaultSubscriber.getAvailableSegments();
                            if (this.isEqualCollections(availableSegments, nowAvailableSegments)) continue;
                            defaultSubscriber.setAvailableSegments(availableSegments);
                            this.observerHandler.notify(defaultSubscriber);
                        }
                        catch (Exception e) {
                            SyncConfigThread.LOGGER.error("[syncConfig] try notify subscriber error, registId: {}, availableSegments: {}", new Object[]{subscriber.getRegistId(), availableSegments, e});
                        }
                    }
                    break;
                }
            }
            catch (Throwable e) {
                SyncConfigThread.LOGGER.error("[syncConfig] sync config error, retryInterval: {}", (Object)retryInterval, (Object)e);
                continue;
            }
            break;
        }
    }

    private boolean isEqualCollections(Collection<String> a, Collection<String> b) {
        if (null == a) {
            a = new ArrayList<String>();
        }
        if (null == b) {
            b = new ArrayList<String>();
        }
        return a.size() == b.size() && a.equals(b);
    }
}

