/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.filter.custom;

import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbCallableStatement;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbIntervalDT;
import dm.jdbc.driver.DmdbIntervalYM;
import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.driver.DmdbTimestamp;
import dm.jdbc.filter.BaseFilter;
import dm.jdbc.filter.FilterChain;
import dm.jdbc.filter.custom.ICustom;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public class CustomFilter
extends BaseFilter {
    private ICustom custom;
    private static final Map retMaps = new HashMap();
    private static final Map batchRowParams = new HashMap();
    private static final Map curRowParams = new HashMap();

    private CustomFilter(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            this.custom = (ICustom)clazz.newInstance();
        }
        catch (Exception exception) {
            DBError.throwRuntimeException("Create custom filter error!", exception);
        }
    }

    public static CustomFilter getInstance(String string) {
        return new CustomFilter(string);
    }

    private Map beforePrepare(String string) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (string != null) {
            hashMap.put("sql", string);
        }
        hashMap.put("prepare", true);
        return hashMap;
    }

    private void afterPrepare(Statement statement, Map map) {
        map.put("statement", statement);
        retMaps.put(statement, map);
        this.custom.afterPrepare(map);
    }

    private boolean beforeExecute(Statement statement, String string) {
        HashMap<String, String> hashMap = null;
        if (statement instanceof PreparedStatement) {
            hashMap = (HashMap<String, String>)retMaps.get(statement);
        }
        if (hashMap == null) {
            hashMap = new HashMap<String, String>();
            hashMap.put("statement", (String)((Object)statement));
            retMaps.put(statement, hashMap);
        }
        if (string != null) {
            hashMap.put("sql", string);
        }
        if (statement instanceof PreparedStatement) {
            ArrayList<Map> arrayList = (ArrayList<Map>)batchRowParams.get(statement);
            if (arrayList == null) {
                arrayList = new ArrayList<Map>();
                Map map = (Map)curRowParams.get(statement);
                if (map != null) {
                    arrayList.add(map);
                }
            }
            hashMap.put("params", (String)((Object)arrayList));
        }
        hashMap.put("prepare", (String)((Object)Boolean.valueOf(string == null)));
        return this.custom.beforeExecute(hashMap);
    }

    private void afterExecute(Statement statement) {
        curRowParams.remove(statement);
        batchRowParams.remove(statement);
        Map map = (Map)retMaps.get(statement);
        this.custom.afterExecute(map);
    }

    private void bindParam(DmdbPreparedStatement dmdbPreparedStatement, int n2, Object object) {
        HashMap<String, Object> hashMap = (HashMap<String, Object>)curRowParams.get(dmdbPreparedStatement);
        if (hashMap == null) {
            hashMap = new HashMap<String, Object>();
            curRowParams.put(dmdbPreparedStatement, hashMap);
        }
        hashMap.put("" + n2, object);
    }

    private void bindParam(DmdbPreparedStatement dmdbPreparedStatement, String string, Object object) {
        HashMap<String, Object> hashMap = (HashMap<String, Object>)curRowParams.get(dmdbPreparedStatement);
        if (hashMap == null) {
            hashMap = new HashMap<String, Object>();
            curRowParams.put(dmdbPreparedStatement, hashMap);
        }
        hashMap.put(string, object);
    }

    @Override
    public void PreparedStatement_addBatch(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement) {
        Map map = (Map)curRowParams.get(dmdbPreparedStatement);
        if (map != null) {
            ArrayList<Map> arrayList = (ArrayList<Map>)batchRowParams.get(dmdbPreparedStatement);
            if (arrayList == null) {
                arrayList = new ArrayList<Map>();
                batchRowParams.put(dmdbPreparedStatement, arrayList);
            }
            arrayList.add(map);
            curRowParams.remove(dmdbPreparedStatement);
        }
        filterChain.PreparedStatement_addBatch(dmdbPreparedStatement);
    }

    @Override
    public void PreparedStatement_setNull(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, int n3) {
        this.bindParam(dmdbPreparedStatement, n2, null);
        filterChain.PreparedStatement_setNull(dmdbPreparedStatement, n2, n3);
    }

    @Override
    public void PreparedStatement_setBoolean(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, boolean bl) {
        this.bindParam(dmdbPreparedStatement, n2, (Object)bl);
        filterChain.PreparedStatement_setBoolean(dmdbPreparedStatement, n2, bl);
    }

    @Override
    public void PreparedStatement_setByte(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, byte by) {
        this.bindParam(dmdbPreparedStatement, n2, (Object)by);
        filterChain.PreparedStatement_setByte(dmdbPreparedStatement, n2, by);
    }

    @Override
    public void PreparedStatement_setShort(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, short s2) {
        this.bindParam(dmdbPreparedStatement, n2, (Object)s2);
        filterChain.PreparedStatement_setShort(dmdbPreparedStatement, n2, s2);
    }

    @Override
    public void PreparedStatement_setInt(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, int n3) {
        this.bindParam(dmdbPreparedStatement, n2, (Object)n3);
        filterChain.PreparedStatement_setInt(dmdbPreparedStatement, n2, n3);
    }

    @Override
    public void PreparedStatement_setLong(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, long l2) {
        this.bindParam(dmdbPreparedStatement, n2, (Object)l2);
        filterChain.PreparedStatement_setLong(dmdbPreparedStatement, n2, l2);
    }

    @Override
    public void PreparedStatement_setFloat(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, float f2) {
        this.bindParam(dmdbPreparedStatement, n2, (Object)Float.valueOf(f2));
        filterChain.PreparedStatement_setFloat(dmdbPreparedStatement, n2, f2);
    }

    @Override
    public void PreparedStatement_setDouble(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, double d2) {
        this.bindParam(dmdbPreparedStatement, n2, (Object)d2);
        filterChain.PreparedStatement_setDouble(dmdbPreparedStatement, n2, d2);
    }

    @Override
    public void PreparedStatement_setBigDecimal(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, BigDecimal bigDecimal) {
        this.bindParam(dmdbPreparedStatement, n2, (Object)bigDecimal);
        filterChain.PreparedStatement_setBigDecimal(dmdbPreparedStatement, n2, bigDecimal);
    }

    @Override
    public void PreparedStatement_setString(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, String string) {
        this.bindParam(dmdbPreparedStatement, n2, (Object)string);
        filterChain.PreparedStatement_setString(dmdbPreparedStatement, n2, string);
    }

    @Override
    public void PreparedStatement_setBytes(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, byte[] byArray) {
        this.bindParam(dmdbPreparedStatement, n2, (Object)byArray);
        filterChain.PreparedStatement_setBytes(dmdbPreparedStatement, n2, byArray);
    }

    @Override
    public void PreparedStatement_setDate(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, Date date) {
        this.bindParam(dmdbPreparedStatement, n2, (Object)date);
        filterChain.PreparedStatement_setDate(dmdbPreparedStatement, n2, date);
    }

    @Override
    public void PreparedStatement_setTime(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, Time time) {
        this.bindParam(dmdbPreparedStatement, n2, (Object)time);
        filterChain.PreparedStatement_setTime(dmdbPreparedStatement, n2, time);
    }

    @Override
    public void PreparedStatement_setTimestamp(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, Timestamp timestamp) {
        this.bindParam(dmdbPreparedStatement, n2, (Object)timestamp);
        filterChain.PreparedStatement_setTimestamp(dmdbPreparedStatement, n2, timestamp);
    }

    @Override
    public void PreparedStatement_setAsciiStream(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, InputStream inputStream, int n3) {
        this.bindParam(dmdbPreparedStatement, n2, (Object)inputStream);
        filterChain.PreparedStatement_setAsciiStream(dmdbPreparedStatement, n2, inputStream, n3);
    }

    @Override
    public void PreparedStatement_setUnicodeStream(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, InputStream inputStream, int n3) {
        this.bindParam(dmdbPreparedStatement, n2, (Object)inputStream);
        filterChain.PreparedStatement_setUnicodeStream(dmdbPreparedStatement, n2, inputStream, n3);
    }

    @Override
    public void PreparedStatement_setBinaryStream(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, InputStream inputStream, int n3) {
        this.bindParam(dmdbPreparedStatement, n2, (Object)inputStream);
        filterChain.PreparedStatement_setBinaryStream(dmdbPreparedStatement, n2, inputStream, n3);
    }

    @Override
    public void PreparedStatement_setObject(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, Object object, int n3) {
        this.bindParam(dmdbPreparedStatement, n2, object);
        filterChain.PreparedStatement_setObject(dmdbPreparedStatement, n2, object, n3);
    }

    @Override
    public void PreparedStatement_setObject(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, Object object) {
        this.bindParam(dmdbPreparedStatement, n2, object);
        filterChain.PreparedStatement_setObject(dmdbPreparedStatement, n2, object);
    }

    @Override
    public void PreparedStatement_setCharacterStream(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, Reader reader, int n3) {
        this.bindParam(dmdbPreparedStatement, n2, (Object)reader);
        filterChain.PreparedStatement_setCharacterStream(dmdbPreparedStatement, n2, reader, n3);
    }

    @Override
    public void PreparedStatement_setRef(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, Ref ref) {
        this.bindParam(dmdbPreparedStatement, n2, (Object)ref);
        filterChain.PreparedStatement_setRef(dmdbPreparedStatement, n2, ref);
    }

    @Override
    public void PreparedStatement_setBlob(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, Blob blob) {
        this.bindParam(dmdbPreparedStatement, n2, (Object)blob);
        filterChain.PreparedStatement_setBlob(dmdbPreparedStatement, n2, blob);
    }

    @Override
    public void PreparedStatement_setClob(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, Clob clob) {
        this.bindParam(dmdbPreparedStatement, n2, (Object)clob);
        filterChain.PreparedStatement_setClob(dmdbPreparedStatement, n2, clob);
    }

    @Override
    public void PreparedStatement_setArray(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, Array array) {
        this.bindParam(dmdbPreparedStatement, n2, (Object)array);
        filterChain.PreparedStatement_setArray(dmdbPreparedStatement, n2, array);
    }

    @Override
    public void PreparedStatement_setDate(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, Date date, Calendar calendar) {
        this.bindParam(dmdbPreparedStatement, n2, (Object)date);
        filterChain.PreparedStatement_setDate(dmdbPreparedStatement, n2, date, calendar);
    }

    @Override
    public void PreparedStatement_setTime(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, Time time, Calendar calendar) {
        this.bindParam(dmdbPreparedStatement, n2, (Object)time);
        filterChain.PreparedStatement_setTime(dmdbPreparedStatement, n2, time, calendar);
    }

    @Override
    public void PreparedStatement_setTimestamp(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, Timestamp timestamp, Calendar calendar) {
        this.bindParam(dmdbPreparedStatement, n2, (Object)timestamp);
        filterChain.PreparedStatement_setTimestamp(dmdbPreparedStatement, n2, timestamp, calendar);
    }

    @Override
    public void PreparedStatement_setNull(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, int n3, String string) {
        this.bindParam(dmdbPreparedStatement, n2, null);
        filterChain.PreparedStatement_setNull(dmdbPreparedStatement, n2, n3, string);
    }

    @Override
    public void PreparedStatement_setURL(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, URL uRL) {
        this.bindParam(dmdbPreparedStatement, n2, (Object)uRL);
        filterChain.PreparedStatement_setURL(dmdbPreparedStatement, n2, uRL);
    }

    @Override
    public void PreparedStatement_setRowId(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, RowId rowId) {
        this.bindParam(dmdbPreparedStatement, n2, (Object)rowId);
        filterChain.PreparedStatement_setRowId(dmdbPreparedStatement, n2, rowId);
    }

    @Override
    public void PreparedStatement_setNString(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, String string) {
        this.bindParam(dmdbPreparedStatement, n2, (Object)string);
        filterChain.PreparedStatement_setNString(dmdbPreparedStatement, n2, string);
    }

    @Override
    public void PreparedStatement_setNCharacterStream(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, Reader reader, long l2) {
        this.bindParam(dmdbPreparedStatement, n2, (Object)reader);
        filterChain.PreparedStatement_setNCharacterStream(dmdbPreparedStatement, n2, reader, l2);
    }

    @Override
    public void PreparedStatement_setNClob(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, NClob nClob) {
        this.bindParam(dmdbPreparedStatement, n2, (Object)nClob);
        filterChain.PreparedStatement_setNClob(dmdbPreparedStatement, n2, nClob);
    }

    @Override
    public void PreparedStatement_setClob(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, Reader reader, long l2) {
        this.bindParam(dmdbPreparedStatement, n2, (Object)reader);
        filterChain.PreparedStatement_setClob(dmdbPreparedStatement, n2, reader, l2);
    }

    @Override
    public void PreparedStatement_setBlob(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, InputStream inputStream, long l2) {
        this.bindParam(dmdbPreparedStatement, n2, (Object)inputStream);
        filterChain.PreparedStatement_setBlob(dmdbPreparedStatement, n2, inputStream, l2);
    }

    @Override
    public void PreparedStatement_setNClob(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, Reader reader, long l2) {
        this.bindParam(dmdbPreparedStatement, n2, (Object)reader);
        filterChain.PreparedStatement_setNClob(dmdbPreparedStatement, n2, reader, l2);
    }

    @Override
    public void PreparedStatement_setSQLXML(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, SQLXML sQLXML) {
        this.bindParam(dmdbPreparedStatement, n2, (Object)sQLXML);
        filterChain.PreparedStatement_setSQLXML(dmdbPreparedStatement, n2, sQLXML);
    }

    @Override
    public void PreparedStatement_setObject(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, Object object, int n3, int n4) {
        this.bindParam(dmdbPreparedStatement, n2, object);
        filterChain.PreparedStatement_setObject(dmdbPreparedStatement, n2, object, n3, n4);
    }

    @Override
    public void PreparedStatement_setAsciiStream(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, InputStream inputStream, long l2) {
        this.bindParam(dmdbPreparedStatement, n2, (Object)inputStream);
        filterChain.PreparedStatement_setAsciiStream(dmdbPreparedStatement, n2, inputStream, l2);
    }

    @Override
    public void PreparedStatement_setBinaryStream(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, InputStream inputStream, long l2) {
        this.bindParam(dmdbPreparedStatement, n2, (Object)inputStream);
        filterChain.PreparedStatement_setBinaryStream(dmdbPreparedStatement, n2, inputStream, l2);
    }

    @Override
    public void PreparedStatement_setCharacterStream(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, Reader reader, long l2) {
        this.bindParam(dmdbPreparedStatement, n2, (Object)reader);
        filterChain.PreparedStatement_setCharacterStream(dmdbPreparedStatement, n2, reader, l2);
    }

    @Override
    public void PreparedStatement_setAsciiStream(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, InputStream inputStream) {
        this.bindParam(dmdbPreparedStatement, n2, (Object)inputStream);
        filterChain.PreparedStatement_setAsciiStream(dmdbPreparedStatement, n2, inputStream);
    }

    @Override
    public void PreparedStatement_setBinaryStream(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, InputStream inputStream) {
        this.bindParam(dmdbPreparedStatement, n2, (Object)inputStream);
        filterChain.PreparedStatement_setBinaryStream(dmdbPreparedStatement, n2, inputStream);
    }

    @Override
    public void PreparedStatement_setCharacterStream(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, Reader reader) {
        this.bindParam(dmdbPreparedStatement, n2, (Object)reader);
        filterChain.PreparedStatement_setCharacterStream(dmdbPreparedStatement, n2, reader);
    }

    @Override
    public void PreparedStatement_setNCharacterStream(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, Reader reader) {
        this.bindParam(dmdbPreparedStatement, n2, (Object)reader);
        filterChain.PreparedStatement_setNCharacterStream(dmdbPreparedStatement, n2, reader);
    }

    @Override
    public void PreparedStatement_setClob(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, Reader reader) {
        this.bindParam(dmdbPreparedStatement, n2, (Object)reader);
        filterChain.PreparedStatement_setClob(dmdbPreparedStatement, n2, reader);
    }

    @Override
    public void PreparedStatement_setBlob(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, InputStream inputStream) {
        this.bindParam(dmdbPreparedStatement, n2, (Object)inputStream);
        filterChain.PreparedStatement_setBlob(dmdbPreparedStatement, n2, inputStream);
    }

    @Override
    public void PreparedStatement_setNClob(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, Reader reader) {
        this.bindParam(dmdbPreparedStatement, n2, (Object)reader);
        filterChain.PreparedStatement_setNClob(dmdbPreparedStatement, n2, reader);
    }

    @Override
    public void PreparedStatement_setObject(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, Object object, SQLType sQLType, int n3) {
        this.bindParam(dmdbPreparedStatement, n2, object);
        filterChain.PreparedStatement_setObject(dmdbPreparedStatement, n2, object, sQLType, n3);
    }

    @Override
    public void PreparedStatement_setObject(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, Object object, SQLType sQLType) {
        this.bindParam(dmdbPreparedStatement, n2, object);
        filterChain.PreparedStatement_setObject(dmdbPreparedStatement, n2, object, sQLType);
    }

    @Override
    public void PreparedStatement_setTIMESTAMP(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, DmdbTimestamp dmdbTimestamp) {
        this.bindParam(dmdbPreparedStatement, n2, (Object)dmdbTimestamp);
        filterChain.PreparedStatement_setTIMESTAMP(dmdbPreparedStatement, n2, dmdbTimestamp);
    }

    @Override
    public void PreparedStatement_setINTERVALYM(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, DmdbIntervalYM dmdbIntervalYM) {
        this.bindParam(dmdbPreparedStatement, n2, (Object)dmdbIntervalYM);
        filterChain.PreparedStatement_setINTERVALYM(dmdbPreparedStatement, n2, dmdbIntervalYM);
    }

    @Override
    public void PreparedStatement_setINTERVALDT(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement, int n2, DmdbIntervalDT dmdbIntervalDT) {
        this.bindParam(dmdbPreparedStatement, n2, (Object)dmdbIntervalDT);
        filterChain.PreparedStatement_setINTERVALDT(dmdbPreparedStatement, n2, dmdbIntervalDT);
    }

    @Override
    public void CallableStatement_setINTERVALDT(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, DmdbIntervalDT dmdbIntervalDT) {
        this.bindParam((DmdbPreparedStatement)dmdbCallableStatement, string, (Object)dmdbIntervalDT);
        filterChain.CallableStatement_setINTERVALDT(dmdbCallableStatement, string, dmdbIntervalDT);
    }

    @Override
    public void CallableStatement_setINTERVALYM(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, DmdbIntervalYM dmdbIntervalYM) {
        this.bindParam((DmdbPreparedStatement)dmdbCallableStatement, string, (Object)dmdbIntervalYM);
        filterChain.CallableStatement_setINTERVALYM(dmdbCallableStatement, string, dmdbIntervalYM);
    }

    @Override
    public void CallableStatement_setTIMESTAMP(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, DmdbTimestamp dmdbTimestamp) {
        this.bindParam((DmdbPreparedStatement)dmdbCallableStatement, string, (Object)dmdbTimestamp);
        filterChain.CallableStatement_setTIMESTAMP(dmdbCallableStatement, string, dmdbTimestamp);
    }

    @Override
    public void CallableStatement_setURL(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, URL uRL) {
        this.bindParam((DmdbPreparedStatement)dmdbCallableStatement, string, (Object)uRL);
        filterChain.CallableStatement_setURL(dmdbCallableStatement, string, uRL);
    }

    @Override
    public void CallableStatement_setNull(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, int n2) {
        this.bindParam((DmdbPreparedStatement)dmdbCallableStatement, string, null);
        filterChain.CallableStatement_setNull(dmdbCallableStatement, string, n2);
    }

    @Override
    public void CallableStatement_setBoolean(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, boolean bl) {
        this.bindParam((DmdbPreparedStatement)dmdbCallableStatement, string, (Object)bl);
        filterChain.CallableStatement_setBoolean(dmdbCallableStatement, string, bl);
    }

    @Override
    public void CallableStatement_setByte(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, byte by) {
        this.bindParam((DmdbPreparedStatement)dmdbCallableStatement, string, (Object)by);
        filterChain.CallableStatement_setByte(dmdbCallableStatement, string, by);
    }

    @Override
    public void CallableStatement_setShort(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, short s2) {
        this.bindParam((DmdbPreparedStatement)dmdbCallableStatement, string, (Object)s2);
        filterChain.CallableStatement_setShort(dmdbCallableStatement, string, s2);
    }

    @Override
    public void CallableStatement_setInt(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, int n2) {
        this.bindParam((DmdbPreparedStatement)dmdbCallableStatement, string, (Object)n2);
        filterChain.CallableStatement_setInt(dmdbCallableStatement, string, n2);
    }

    @Override
    public void CallableStatement_setLong(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, long l2) {
        this.bindParam((DmdbPreparedStatement)dmdbCallableStatement, string, (Object)l2);
        filterChain.CallableStatement_setLong(dmdbCallableStatement, string, l2);
    }

    @Override
    public void CallableStatement_setFloat(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, float f2) {
        this.bindParam((DmdbPreparedStatement)dmdbCallableStatement, string, (Object)Float.valueOf(f2));
        filterChain.CallableStatement_setFloat(dmdbCallableStatement, string, f2);
    }

    @Override
    public void CallableStatement_setDouble(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, double d2) {
        this.bindParam((DmdbPreparedStatement)dmdbCallableStatement, string, (Object)d2);
        filterChain.CallableStatement_setDouble(dmdbCallableStatement, string, d2);
    }

    @Override
    public void CallableStatement_setBigDecimal(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, BigDecimal bigDecimal) {
        this.bindParam((DmdbPreparedStatement)dmdbCallableStatement, string, (Object)bigDecimal);
        filterChain.CallableStatement_setBigDecimal(dmdbCallableStatement, string, bigDecimal);
    }

    @Override
    public void CallableStatement_setString(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, String string2) {
        this.bindParam((DmdbPreparedStatement)dmdbCallableStatement, string, (Object)string2);
        filterChain.CallableStatement_setString(dmdbCallableStatement, string, string2);
    }

    @Override
    public void CallableStatement_setBytes(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, byte[] byArray) {
        this.bindParam((DmdbPreparedStatement)dmdbCallableStatement, string, (Object)byArray);
        filterChain.CallableStatement_setBytes(dmdbCallableStatement, string, byArray);
    }

    @Override
    public void CallableStatement_setDate(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, Date date) {
        this.bindParam((DmdbPreparedStatement)dmdbCallableStatement, string, (Object)date);
        filterChain.CallableStatement_setDate(dmdbCallableStatement, string, date);
    }

    @Override
    public void CallableStatement_setTime(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, Time time) {
        this.bindParam((DmdbPreparedStatement)dmdbCallableStatement, string, (Object)time);
        filterChain.CallableStatement_setTime(dmdbCallableStatement, string, time);
    }

    @Override
    public void CallableStatement_setTimestamp(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, Timestamp timestamp) {
        this.bindParam((DmdbPreparedStatement)dmdbCallableStatement, string, (Object)timestamp);
        filterChain.CallableStatement_setTimestamp(dmdbCallableStatement, string, timestamp);
    }

    @Override
    public void CallableStatement_setAsciiStream(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, InputStream inputStream, int n2) {
        this.bindParam((DmdbPreparedStatement)dmdbCallableStatement, string, (Object)inputStream);
        filterChain.CallableStatement_setAsciiStream(dmdbCallableStatement, string, inputStream, n2);
    }

    @Override
    public void CallableStatement_setBinaryStream(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, InputStream inputStream, int n2) {
        this.bindParam((DmdbPreparedStatement)dmdbCallableStatement, string, (Object)inputStream);
        filterChain.CallableStatement_setBinaryStream(dmdbCallableStatement, string, inputStream, n2);
    }

    @Override
    public void CallableStatement_setObject(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, Object object, int n2, int n3) {
        this.bindParam((DmdbPreparedStatement)dmdbCallableStatement, string, object);
        filterChain.CallableStatement_setObject(dmdbCallableStatement, string, object, n2, n3);
    }

    @Override
    public void CallableStatement_setObject(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, Object object, int n2) {
        this.bindParam((DmdbPreparedStatement)dmdbCallableStatement, string, object);
        filterChain.CallableStatement_setObject(dmdbCallableStatement, string, object, n2);
    }

    @Override
    public void CallableStatement_setObject(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, Object object) {
        this.bindParam((DmdbPreparedStatement)dmdbCallableStatement, string, object);
        filterChain.CallableStatement_setObject(dmdbCallableStatement, string, object);
    }

    @Override
    public void CallableStatement_setCharacterStream(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, Reader reader, int n2) {
        this.bindParam((DmdbPreparedStatement)dmdbCallableStatement, string, (Object)reader);
        filterChain.CallableStatement_setCharacterStream(dmdbCallableStatement, string, reader, n2);
    }

    @Override
    public void CallableStatement_setDate(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, Date date, Calendar calendar) {
        this.bindParam((DmdbPreparedStatement)dmdbCallableStatement, string, (Object)date);
        filterChain.CallableStatement_setDate(dmdbCallableStatement, string, date, calendar);
    }

    @Override
    public void CallableStatement_setTime(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, Time time, Calendar calendar) {
        this.bindParam((DmdbPreparedStatement)dmdbCallableStatement, string, (Object)time);
        filterChain.CallableStatement_setTime(dmdbCallableStatement, string, time, calendar);
    }

    @Override
    public void CallableStatement_setTimestamp(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, Timestamp timestamp, Calendar calendar) {
        this.bindParam((DmdbPreparedStatement)dmdbCallableStatement, string, (Object)timestamp);
        filterChain.CallableStatement_setTimestamp(dmdbCallableStatement, string, timestamp, calendar);
    }

    @Override
    public void CallableStatement_setNull(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, int n2, String string2) {
        this.bindParam((DmdbPreparedStatement)dmdbCallableStatement, string, null);
        filterChain.CallableStatement_setNull(dmdbCallableStatement, string, n2, string2);
    }

    @Override
    public void CallableStatement_setRowId(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, RowId rowId) {
        this.bindParam((DmdbPreparedStatement)dmdbCallableStatement, string, (Object)rowId);
        filterChain.CallableStatement_setRowId(dmdbCallableStatement, string, rowId);
    }

    @Override
    public void CallableStatement_setNString(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, String string2) {
        this.bindParam((DmdbPreparedStatement)dmdbCallableStatement, string, (Object)string2);
        filterChain.CallableStatement_setNString(dmdbCallableStatement, string, string2);
    }

    @Override
    public void CallableStatement_setNCharacterStream(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, Reader reader, long l2) {
        this.bindParam((DmdbPreparedStatement)dmdbCallableStatement, string, (Object)reader);
        filterChain.CallableStatement_setNCharacterStream(dmdbCallableStatement, string, reader, l2);
    }

    @Override
    public void CallableStatement_setNClob(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, NClob nClob) {
        this.bindParam((DmdbPreparedStatement)dmdbCallableStatement, string, (Object)nClob);
        filterChain.CallableStatement_setNClob(dmdbCallableStatement, string, nClob);
    }

    @Override
    public void CallableStatement_setClob(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, Reader reader, long l2) {
        this.bindParam((DmdbPreparedStatement)dmdbCallableStatement, string, (Object)reader);
        filterChain.CallableStatement_setClob(dmdbCallableStatement, string, reader, l2);
    }

    @Override
    public void CallableStatement_setBlob(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, InputStream inputStream, long l2) {
        this.bindParam((DmdbPreparedStatement)dmdbCallableStatement, string, (Object)inputStream);
        filterChain.CallableStatement_setBlob(dmdbCallableStatement, string, inputStream, l2);
    }

    @Override
    public void CallableStatement_setNClob(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, Reader reader, long l2) {
        this.bindParam((DmdbPreparedStatement)dmdbCallableStatement, string, (Object)reader);
        filterChain.CallableStatement_setNClob(dmdbCallableStatement, string, reader, l2);
    }

    @Override
    public void CallableStatement_setSQLXML(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, SQLXML sQLXML) {
        this.bindParam((DmdbPreparedStatement)dmdbCallableStatement, string, (Object)sQLXML);
        filterChain.CallableStatement_setSQLXML(dmdbCallableStatement, string, sQLXML);
    }

    @Override
    public void CallableStatement_setBlob(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, Blob blob) {
        this.bindParam((DmdbPreparedStatement)dmdbCallableStatement, string, (Object)blob);
        filterChain.CallableStatement_setBlob(dmdbCallableStatement, string, blob);
    }

    @Override
    public void CallableStatement_setClob(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, Clob clob) {
        this.bindParam((DmdbPreparedStatement)dmdbCallableStatement, string, (Object)clob);
        filterChain.CallableStatement_setClob(dmdbCallableStatement, string, clob);
    }

    @Override
    public void CallableStatement_setAsciiStream(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, InputStream inputStream, long l2) {
        this.bindParam((DmdbPreparedStatement)dmdbCallableStatement, string, (Object)inputStream);
        filterChain.CallableStatement_setAsciiStream(dmdbCallableStatement, string, inputStream, l2);
    }

    @Override
    public void CallableStatement_setBinaryStream(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, InputStream inputStream, long l2) {
        this.bindParam((DmdbPreparedStatement)dmdbCallableStatement, string, (Object)inputStream);
        filterChain.CallableStatement_setBinaryStream(dmdbCallableStatement, string, inputStream, l2);
    }

    @Override
    public void CallableStatement_setCharacterStream(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, Reader reader, long l2) {
        this.bindParam((DmdbPreparedStatement)dmdbCallableStatement, string, (Object)reader);
        filterChain.CallableStatement_setCharacterStream(dmdbCallableStatement, string, reader, l2);
    }

    @Override
    public void CallableStatement_setAsciiStream(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, InputStream inputStream) {
        this.bindParam((DmdbPreparedStatement)dmdbCallableStatement, string, (Object)inputStream);
        filterChain.CallableStatement_setAsciiStream(dmdbCallableStatement, string, inputStream);
    }

    @Override
    public void CallableStatement_setBinaryStream(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, InputStream inputStream) {
        this.bindParam((DmdbPreparedStatement)dmdbCallableStatement, string, (Object)inputStream);
        filterChain.CallableStatement_setBinaryStream(dmdbCallableStatement, string, inputStream);
    }

    @Override
    public void CallableStatement_setCharacterStream(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, Reader reader) {
        this.bindParam((DmdbPreparedStatement)dmdbCallableStatement, string, (Object)reader);
        filterChain.CallableStatement_setCharacterStream(dmdbCallableStatement, string, reader);
    }

    @Override
    public void CallableStatement_setNCharacterStream(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, Reader reader) {
        this.bindParam((DmdbPreparedStatement)dmdbCallableStatement, string, (Object)reader);
        filterChain.CallableStatement_setNCharacterStream(dmdbCallableStatement, string, reader);
    }

    @Override
    public void CallableStatement_setClob(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, Reader reader) {
        this.bindParam((DmdbPreparedStatement)dmdbCallableStatement, string, (Object)reader);
        filterChain.CallableStatement_setClob(dmdbCallableStatement, string, reader);
    }

    @Override
    public void CallableStatement_setBlob(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, InputStream inputStream) {
        this.bindParam((DmdbPreparedStatement)dmdbCallableStatement, string, (Object)inputStream);
        filterChain.CallableStatement_setBlob(dmdbCallableStatement, string, inputStream);
    }

    @Override
    public void CallableStatement_setNClob(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, Reader reader) {
        this.bindParam((DmdbPreparedStatement)dmdbCallableStatement, string, (Object)reader);
        filterChain.CallableStatement_setNClob(dmdbCallableStatement, string, reader);
    }

    @Override
    public void CallableStatement_setObject(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, Object object, SQLType sQLType, int n2) {
        this.bindParam((DmdbPreparedStatement)dmdbCallableStatement, string, object);
        filterChain.CallableStatement_setObject(dmdbCallableStatement, string, object, sQLType, n2);
    }

    @Override
    public void CallableStatement_setObject(FilterChain filterChain, DmdbCallableStatement dmdbCallableStatement, String string, Object object, SQLType sQLType) {
        this.bindParam((DmdbPreparedStatement)dmdbCallableStatement, string, object);
        filterChain.CallableStatement_setObject(dmdbCallableStatement, string, object, sQLType);
    }

    @Override
    public PreparedStatement Connection_prepareStatement(FilterChain filterChain, DmdbConnection dmdbConnection, String string) {
        PreparedStatement preparedStatement;
        Map map;
        block3: {
            map = null;
            preparedStatement = null;
            try {
                map = this.beforePrepare(string);
                if (this.custom.beforePrepare(map)) break block3;
                this.afterPrepare(preparedStatement, map);
                return null;
            }
            catch (Throwable throwable) {
                this.afterPrepare(preparedStatement, map);
                throw throwable;
            }
        }
        PreparedStatement preparedStatement2 = preparedStatement = super.Connection_prepareStatement(filterChain, dmdbConnection, string);
        this.afterPrepare(preparedStatement, map);
        return preparedStatement2;
    }

    @Override
    public PreparedStatement Connection_prepareStatement(FilterChain filterChain, DmdbConnection dmdbConnection, String string, int n2) {
        PreparedStatement preparedStatement;
        Map map;
        block3: {
            map = null;
            preparedStatement = null;
            try {
                map = this.beforePrepare(string);
                if (this.custom.beforePrepare(map)) break block3;
                this.afterPrepare(preparedStatement, map);
                return null;
            }
            catch (Throwable throwable) {
                this.afterPrepare(preparedStatement, map);
                throw throwable;
            }
        }
        PreparedStatement preparedStatement2 = preparedStatement = super.Connection_prepareStatement(filterChain, dmdbConnection, string, n2);
        this.afterPrepare(preparedStatement, map);
        return preparedStatement2;
    }

    @Override
    public PreparedStatement Connection_prepareStatement(FilterChain filterChain, DmdbConnection dmdbConnection, String string, int n2, int n3) {
        PreparedStatement preparedStatement;
        Map map;
        block3: {
            map = null;
            preparedStatement = null;
            try {
                map = this.beforePrepare(string);
                if (this.custom.beforePrepare(map)) break block3;
                this.afterPrepare(preparedStatement, map);
                return null;
            }
            catch (Throwable throwable) {
                this.afterPrepare(preparedStatement, map);
                throw throwable;
            }
        }
        PreparedStatement preparedStatement2 = preparedStatement = super.Connection_prepareStatement(filterChain, dmdbConnection, string, n2, n3);
        this.afterPrepare(preparedStatement, map);
        return preparedStatement2;
    }

    @Override
    public PreparedStatement Connection_prepareStatement(FilterChain filterChain, DmdbConnection dmdbConnection, String string, int n2, int n3, int n4) {
        PreparedStatement preparedStatement;
        Map map;
        block3: {
            map = null;
            preparedStatement = null;
            try {
                map = this.beforePrepare(string);
                if (this.custom.beforePrepare(map)) break block3;
                this.afterPrepare(preparedStatement, map);
                return null;
            }
            catch (Throwable throwable) {
                this.afterPrepare(preparedStatement, map);
                throw throwable;
            }
        }
        PreparedStatement preparedStatement2 = preparedStatement = super.Connection_prepareStatement(filterChain, dmdbConnection, string, n2, n3, n4);
        this.afterPrepare(preparedStatement, map);
        return preparedStatement2;
    }

    @Override
    public PreparedStatement Connection_prepareStatement(FilterChain filterChain, DmdbConnection dmdbConnection, String string, int[] nArray) {
        PreparedStatement preparedStatement;
        Map map;
        block3: {
            map = null;
            preparedStatement = null;
            try {
                map = this.beforePrepare(string);
                if (this.custom.beforePrepare(map)) break block3;
                this.afterPrepare(preparedStatement, map);
                return null;
            }
            catch (Throwable throwable) {
                this.afterPrepare(preparedStatement, map);
                throw throwable;
            }
        }
        PreparedStatement preparedStatement2 = preparedStatement = super.Connection_prepareStatement(filterChain, dmdbConnection, string, nArray);
        this.afterPrepare(preparedStatement, map);
        return preparedStatement2;
    }

    @Override
    public PreparedStatement Connection_prepareStatement(FilterChain filterChain, DmdbConnection dmdbConnection, String string, String[] stringArray) {
        PreparedStatement preparedStatement;
        Map map;
        block3: {
            map = null;
            preparedStatement = null;
            try {
                map = this.beforePrepare(string);
                if (this.custom.beforePrepare(map)) break block3;
                this.afterPrepare(preparedStatement, map);
                return null;
            }
            catch (Throwable throwable) {
                this.afterPrepare(preparedStatement, map);
                throw throwable;
            }
        }
        PreparedStatement preparedStatement2 = preparedStatement = super.Connection_prepareStatement(filterChain, dmdbConnection, string, stringArray);
        this.afterPrepare(preparedStatement, map);
        return preparedStatement2;
    }

    @Override
    public CallableStatement Connection_prepareCall(FilterChain filterChain, DmdbConnection dmdbConnection, String string) {
        CallableStatement callableStatement;
        Map map;
        block3: {
            map = null;
            callableStatement = null;
            try {
                map = this.beforePrepare(string);
                if (this.custom.beforePrepare(map)) break block3;
                this.afterPrepare(callableStatement, map);
                return null;
            }
            catch (Throwable throwable) {
                this.afterPrepare(callableStatement, map);
                throw throwable;
            }
        }
        CallableStatement callableStatement2 = callableStatement = super.Connection_prepareCall(filterChain, dmdbConnection, string);
        this.afterPrepare(callableStatement, map);
        return callableStatement2;
    }

    @Override
    public CallableStatement Connection_prepareCall(FilterChain filterChain, DmdbConnection dmdbConnection, String string, int n2, int n3) {
        CallableStatement callableStatement;
        Map map;
        block3: {
            map = null;
            callableStatement = null;
            try {
                map = this.beforePrepare(string);
                if (this.custom.beforePrepare(map)) break block3;
                this.afterPrepare(callableStatement, map);
                return null;
            }
            catch (Throwable throwable) {
                this.afterPrepare(callableStatement, map);
                throw throwable;
            }
        }
        CallableStatement callableStatement2 = callableStatement = super.Connection_prepareCall(filterChain, dmdbConnection, string, n2, n3);
        this.afterPrepare(callableStatement, map);
        return callableStatement2;
    }

    @Override
    public CallableStatement Connection_prepareCall(FilterChain filterChain, DmdbConnection dmdbConnection, String string, int n2, int n3, int n4) {
        CallableStatement callableStatement;
        Map map;
        block3: {
            map = null;
            callableStatement = null;
            try {
                map = this.beforePrepare(string);
                if (this.custom.beforePrepare(map)) break block3;
                this.afterPrepare(callableStatement, map);
                return null;
            }
            catch (Throwable throwable) {
                this.afterPrepare(callableStatement, map);
                throw throwable;
            }
        }
        CallableStatement callableStatement2 = callableStatement = super.Connection_prepareCall(filterChain, dmdbConnection, string, n2, n3, n4);
        this.afterPrepare(callableStatement, map);
        return callableStatement2;
    }

    @Override
    public boolean Statement_execute(FilterChain filterChain, DmdbStatement dmdbStatement, String string) {
        try {
            if (!this.beforeExecute(dmdbStatement, string)) {
                return false;
            }
            boolean bl = super.Statement_execute(filterChain, dmdbStatement, string);
            return bl;
        }
        finally {
            this.afterExecute(dmdbStatement);
        }
    }

    @Override
    public boolean Statement_execute(FilterChain filterChain, DmdbStatement dmdbStatement, String string, int[] nArray) {
        try {
            if (!this.beforeExecute(dmdbStatement, string)) {
                return false;
            }
            boolean bl = super.Statement_execute(filterChain, dmdbStatement, string, nArray);
            return bl;
        }
        finally {
            this.afterExecute(dmdbStatement);
        }
    }

    @Override
    public boolean Statement_execute(FilterChain filterChain, DmdbStatement dmdbStatement, String string, int n2) {
        try {
            if (!this.beforeExecute(dmdbStatement, string)) {
                return false;
            }
            boolean bl = super.Statement_execute(filterChain, dmdbStatement, string, n2);
            return bl;
        }
        finally {
            this.afterExecute(dmdbStatement);
        }
    }

    @Override
    public boolean Statement_execute(FilterChain filterChain, DmdbStatement dmdbStatement, String string, String[] stringArray) {
        try {
            if (!this.beforeExecute(dmdbStatement, string)) {
                return false;
            }
            boolean bl = super.Statement_execute(filterChain, dmdbStatement, string, stringArray);
            return bl;
        }
        finally {
            this.afterExecute(dmdbStatement);
        }
    }

    @Override
    public long Statement_executeLargeUpdate(FilterChain filterChain, DmdbStatement dmdbStatement, String string) {
        try {
            if (!this.beforeExecute(dmdbStatement, string)) {
                return 0L;
            }
            long l2 = super.Statement_executeLargeUpdate(filterChain, dmdbStatement, string);
            return l2;
        }
        finally {
            this.afterExecute(dmdbStatement);
        }
    }

    @Override
    public long Statement_executeLargeUpdate(FilterChain filterChain, DmdbStatement dmdbStatement, String string, int n2) {
        try {
            if (!this.beforeExecute(dmdbStatement, string)) {
                return 0L;
            }
            long l2 = super.Statement_executeLargeUpdate(filterChain, dmdbStatement, string, n2);
            return l2;
        }
        finally {
            this.afterExecute(dmdbStatement);
        }
    }

    @Override
    public long Statement_executeLargeUpdate(FilterChain filterChain, DmdbStatement dmdbStatement, String string, int[] nArray) {
        try {
            if (!this.beforeExecute(dmdbStatement, string)) {
                return 0L;
            }
            long l2 = super.Statement_executeLargeUpdate(filterChain, dmdbStatement, string, nArray);
            return l2;
        }
        finally {
            this.afterExecute(dmdbStatement);
        }
    }

    @Override
    public long Statement_executeLargeUpdate(FilterChain filterChain, DmdbStatement dmdbStatement, String string, String[] stringArray) {
        try {
            if (!this.beforeExecute(dmdbStatement, string)) {
                return 0L;
            }
            long l2 = super.Statement_executeLargeUpdate(filterChain, dmdbStatement, string, stringArray);
            return l2;
        }
        finally {
            this.afterExecute(dmdbStatement);
        }
    }

    @Override
    public ResultSet Statement_executeQuery(FilterChain filterChain, DmdbStatement dmdbStatement, String string) {
        try {
            if (!this.beforeExecute(dmdbStatement, string)) {
                return null;
            }
            ResultSet resultSet = super.Statement_executeQuery(filterChain, dmdbStatement, string);
            return resultSet;
        }
        finally {
            this.afterExecute(dmdbStatement);
        }
    }

    @Override
    public int Statement_executeUpdate(FilterChain filterChain, DmdbStatement dmdbStatement, String string) {
        try {
            if (!this.beforeExecute(dmdbStatement, string)) {
                return 0;
            }
            int n2 = super.Statement_executeUpdate(filterChain, dmdbStatement, string);
            return n2;
        }
        finally {
            this.afterExecute(dmdbStatement);
        }
    }

    @Override
    public int Statement_executeUpdate(FilterChain filterChain, DmdbStatement dmdbStatement, String string, int n2) {
        try {
            if (!this.beforeExecute(dmdbStatement, string)) {
                return 0;
            }
            int n3 = super.Statement_executeUpdate(filterChain, dmdbStatement, string, n2);
            return n3;
        }
        finally {
            this.afterExecute(dmdbStatement);
        }
    }

    @Override
    public int Statement_executeUpdate(FilterChain filterChain, DmdbStatement dmdbStatement, String string, int[] nArray) {
        try {
            if (!this.beforeExecute(dmdbStatement, string)) {
                return 0;
            }
            int n2 = super.Statement_executeUpdate(filterChain, dmdbStatement, string, nArray);
            return n2;
        }
        finally {
            this.afterExecute(dmdbStatement);
        }
    }

    @Override
    public int Statement_executeUpdate(FilterChain filterChain, DmdbStatement dmdbStatement, String string, String[] stringArray) {
        try {
            if (!this.beforeExecute(dmdbStatement, string)) {
                return 0;
            }
            int n2 = super.Statement_executeUpdate(filterChain, dmdbStatement, string, stringArray);
            return n2;
        }
        finally {
            this.afterExecute(dmdbStatement);
        }
    }

    @Override
    public int[] Statement_executeBatch(FilterChain filterChain, DmdbStatement dmdbStatement) {
        try {
            if (!this.beforeExecute(dmdbStatement, Arrays.toString(dmdbStatement.batchSqls.toArray()))) {
                return null;
            }
            int[] nArray = super.Statement_executeBatch(filterChain, dmdbStatement);
            return nArray;
        }
        finally {
            this.afterExecute(dmdbStatement);
        }
    }

    @Override
    public long[] Statement_executeLargeBatch(FilterChain filterChain, DmdbStatement dmdbStatement) {
        try {
            if (!this.beforeExecute(dmdbStatement, Arrays.toString(dmdbStatement.batchSqls.toArray()))) {
                return null;
            }
            long[] lArray = super.Statement_executeLargeBatch(filterChain, dmdbStatement);
            return lArray;
        }
        finally {
            this.afterExecute(dmdbStatement);
        }
    }

    @Override
    public boolean PreparedStatement_execute(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement) {
        try {
            if (!this.beforeExecute(dmdbPreparedStatement, null)) {
                return false;
            }
            boolean bl = super.PreparedStatement_execute(filterChain, dmdbPreparedStatement);
            return bl;
        }
        finally {
            this.afterExecute(dmdbPreparedStatement);
        }
    }

    @Override
    public int[] PreparedStatement_executeBatch(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement) {
        try {
            if (!this.beforeExecute(dmdbPreparedStatement, null)) {
                return null;
            }
            int[] nArray = super.PreparedStatement_executeBatch(filterChain, dmdbPreparedStatement);
            return nArray;
        }
        finally {
            this.afterExecute(dmdbPreparedStatement);
        }
    }

    @Override
    public long[] PreparedStatement_executeLargeBatch(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement) {
        try {
            if (!this.beforeExecute(dmdbPreparedStatement, null)) {
                return null;
            }
            long[] lArray = super.PreparedStatement_executeLargeBatch(filterChain, dmdbPreparedStatement);
            return lArray;
        }
        finally {
            this.afterExecute(dmdbPreparedStatement);
        }
    }

    @Override
    public long PreparedStatement_executeLargeUpdate(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement) {
        try {
            if (!this.beforeExecute(dmdbPreparedStatement, null)) {
                return 0L;
            }
            long l2 = super.PreparedStatement_executeLargeUpdate(filterChain, dmdbPreparedStatement);
            return l2;
        }
        finally {
            this.afterExecute(dmdbPreparedStatement);
        }
    }

    @Override
    public ResultSet PreparedStatement_executeQuery(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement) {
        try {
            if (!this.beforeExecute(dmdbPreparedStatement, null)) {
                return null;
            }
            ResultSet resultSet = super.PreparedStatement_executeQuery(filterChain, dmdbPreparedStatement);
            return resultSet;
        }
        finally {
            this.afterExecute(dmdbPreparedStatement);
        }
    }

    @Override
    public int PreparedStatement_executeUpdate(FilterChain filterChain, DmdbPreparedStatement dmdbPreparedStatement) {
        try {
            if (!this.beforeExecute(dmdbPreparedStatement, null)) {
                return 0;
            }
            int n2 = super.PreparedStatement_executeUpdate(filterChain, dmdbPreparedStatement);
            return n2;
        }
        finally {
            this.afterExecute(dmdbPreparedStatement);
        }
    }
}

