/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import { TestBed, inject } from '@angular/core/testing';
import { HttpClientTestingModule } from '@angular/common/http/testing';
import { configureTestSuite } from 'ng-bullet';

import { SchedulerService } from './scheduler.service';
import { EnvconfigService } from '@app/services/envconfig/envconfig.service';
import { MockEnvconfigService } from '@app/testing/mocks';

describe('SchedulerService', () => {
  let service: SchedulerService;

  configureTestSuite(() => {
    TestBed.configureTestingModule({
      imports: [HttpClientTestingModule],
      providers: [SchedulerService, { provide: EnvconfigService, useValue: MockEnvconfigService }],
    });
  });

  beforeEach(() => {
    service = TestBed.get(SchedulerService);
  });

  it('should create the service', () => {
    expect(service).toBeTruthy();
  });
});
