/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.executor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.engine.storagegroup.VirtualStorageGroupProcessor;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.idtable.IDTable;
import org.apache.iotdb.db.metadata.idtable.entry.TimeseriesID;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.physical.crud.LastQueryPlan;
import org.apache.iotdb.db.qp.physical.crud.RawDataQueryPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.QueryResourceManager;
import org.apache.iotdb.db.query.dataset.ListDataSet;
import org.apache.iotdb.db.query.executor.fill.LastPointReader;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.expression.impl.GlobalTimeExpression;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LastQueryExecutor {
    private List<PartialPath> selectedSeries;
    private List<TSDataType> dataTypes;
    protected IExpression expression;
    private static final boolean CACHE_ENABLED = IoTDBDescriptor.getInstance().getConfig().isLastCacheEnabled();
    private static final Logger DEBUG_LOGGER = LoggerFactory.getLogger((String)"QUERY_DEBUG");
    private static boolean ID_TABLE_ENABLED = IoTDBDescriptor.getInstance().getConfig().isEnableIDTable();
    private static boolean ascending;
    private static final Logger logger;

    public LastQueryExecutor(LastQueryPlan lastQueryPlan) {
        this.selectedSeries = lastQueryPlan.getDeduplicatedPaths();
        this.dataTypes = lastQueryPlan.getDeduplicatedDataTypes();
        this.expression = lastQueryPlan.getExpression();
        ascending = lastQueryPlan.isAscending();
    }

    public LastQueryExecutor(List<PartialPath> selectedSeries, List<TSDataType> dataTypes) {
        this.selectedSeries = selectedSeries;
        this.dataTypes = dataTypes;
    }

    public QueryDataSet execute(QueryContext context, LastQueryPlan lastQueryPlan) throws StorageEngineException, IOException, QueryProcessException {
        ListDataSet dataSet = new ListDataSet(Arrays.asList(new PartialPath("timeseries", false), new PartialPath("value", false), new PartialPath("dataType", false)), Arrays.asList(TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT));
        List<Pair<Boolean, TimeValuePair>> lastPairList = this.calculateLastPairForSeries(this.selectedSeries, this.dataTypes, context, this.expression, lastQueryPlan);
        for (int i = 0; i < lastPairList.size(); ++i) {
            if (lastPairList.get((int)i).right == null || ((TimeValuePair)lastPairList.get((int)i).right).getValue() == null) continue;
            TimeValuePair lastTimeValuePair = (TimeValuePair)lastPairList.get((int)i).right;
            RowRecord resultRecord = new RowRecord(lastTimeValuePair.getTimestamp());
            Field pathField = new Field(TSDataType.TEXT);
            pathField.setBinaryV(new Binary(lastQueryPlan.getResultColumns().get(i).getResultColumnName()));
            resultRecord.addField(pathField);
            Field valueField = new Field(TSDataType.TEXT);
            valueField.setBinaryV(new Binary(lastTimeValuePair.getValue().getStringValue()));
            resultRecord.addField(valueField);
            Field typeField = new Field(TSDataType.TEXT);
            typeField.setBinaryV(new Binary(lastTimeValuePair.getValue().getDataType().name()));
            resultRecord.addField(typeField);
            dataSet.putRecord(resultRecord);
        }
        if (!lastQueryPlan.isAscending()) {
            dataSet.sortByTime();
        }
        return dataSet;
    }

    protected List<Pair<Boolean, TimeValuePair>> calculateLastPairForSeries(List<PartialPath> seriesPaths, List<TSDataType> dataTypes, QueryContext context, IExpression expression, RawDataQueryPlan lastQueryPlan) throws QueryProcessException, StorageEngineException, IOException {
        return LastQueryExecutor.calculateLastPairForSeriesLocally(seriesPaths, dataTypes, context, expression, lastQueryPlan.getDeviceToMeasurements());
    }

    public static List<Pair<Boolean, TimeValuePair>> calculateLastPairForSeriesLocally(List<PartialPath> seriesPaths, List<TSDataType> dataTypes, QueryContext context, IExpression expression, Map<String, Set<String>> deviceMeasurementsMap) throws QueryProcessException, StorageEngineException, IOException {
        ArrayList<LastCacheAccessor> cacheAccessors = new ArrayList<LastCacheAccessor>();
        Filter filter = expression == null ? null : ((GlobalTimeExpression)expression).getFilter();
        ArrayList<PartialPath> nonCachedPaths = new ArrayList<PartialPath>();
        ArrayList<TSDataType> nonCachedDataTypes = new ArrayList<TSDataType>();
        List<Pair<Boolean, TimeValuePair>> resultContainer = LastQueryExecutor.readLastPairsFromCache(seriesPaths, dataTypes, filter, cacheAccessors, nonCachedPaths, nonCachedDataTypes, context.isDebug());
        if (nonCachedPaths.isEmpty()) {
            return resultContainer;
        }
        ArrayList<LastPointReader> readerList = new ArrayList<LastPointReader>();
        Pair<List<VirtualStorageGroupProcessor>, Map<VirtualStorageGroupProcessor, List<PartialPath>>> lockListAndProcessorToSeriesMapPair = StorageEngine.getInstance().mergeLock(nonCachedPaths);
        List lockList = (List)lockListAndProcessorToSeriesMapPair.left;
        Map processorToSeriesMap = (Map)lockListAndProcessorToSeriesMapPair.right;
        try {
            QueryResourceManager.getInstance().initQueryDataSourceCache(processorToSeriesMap, context, filter);
        }
        catch (Exception e) {
            logger.error("Meet error when init QueryDataSource ", (Throwable)e);
            throw new QueryProcessException("Meet error when init QueryDataSource.", e);
        }
        finally {
            StorageEngine.getInstance().mergeUnLock(lockList);
        }
        for (int i = 0; i < nonCachedPaths.size(); ++i) {
            QueryDataSource dataSource = QueryResourceManager.getInstance().getQueryDataSource((PartialPath)nonCachedPaths.get(i), context, filter, ascending);
            filter = dataSource.updateFilterUsingTTL(filter);
            LastPointReader lastReader = ((PartialPath)nonCachedPaths.get(i)).createLastPointReader((TSDataType)nonCachedDataTypes.get(i), deviceMeasurementsMap.getOrDefault(((PartialPath)nonCachedPaths.get(i)).getDevice(), new HashSet()), context, dataSource, Long.MAX_VALUE, filter);
            readerList.add(lastReader);
        }
        int index = 0;
        for (int i = 0; i < resultContainer.size(); ++i) {
            if (!Boolean.FALSE.equals(resultContainer.get((int)i).left)) continue;
            resultContainer.get((int)i).right = ((LastPointReader)readerList.get(index++)).readLastPoint();
            if (((TimeValuePair)resultContainer.get((int)i).right).getValue() == null) continue;
            resultContainer.get((int)i).left = true;
            if (!CACHE_ENABLED) continue;
            ((LastCacheAccessor)cacheAccessors.get(i)).write((TimeValuePair)resultContainer.get((int)i).right);
            if (!context.isDebug()) continue;
            DEBUG_LOGGER.info("[LastQueryExecutor] Update last cache for path: {} with timestamp: {}", seriesPaths, (Object)((TimeValuePair)resultContainer.get((int)i).right).getTimestamp());
        }
        return resultContainer;
    }

    private static List<Pair<Boolean, TimeValuePair>> readLastPairsFromCache(List<PartialPath> seriesPaths, List<TSDataType> dataTypes, Filter filter, List<LastCacheAccessor> cacheAccessors, List<PartialPath> restPaths, List<TSDataType> restDataType, boolean debugOn) {
        ArrayList<Pair<Boolean, TimeValuePair>> resultContainer = new ArrayList<Pair<Boolean, TimeValuePair>>();
        if (CACHE_ENABLED) {
            for (PartialPath path : seriesPaths) {
                if (ID_TABLE_ENABLED) {
                    cacheAccessors.add(new IDTableLastCacheAccessor(path));
                    continue;
                }
                cacheAccessors.add(new MManagerLastCacheAccessor(path));
            }
        } else {
            for (int i = 0; i < seriesPaths.size(); ++i) {
                resultContainer.add(new Pair((Object)false, null));
                PartialPath p = ((MeasurementPath)seriesPaths.get(i)).transformToExactPath();
                restPaths.add(p);
                restDataType.add(dataTypes.get(i));
            }
        }
        for (int i = 0; i < cacheAccessors.size(); ++i) {
            TimeValuePair tvPair = cacheAccessors.get(i).read();
            if (tvPair == null) {
                resultContainer.add((Pair<Boolean, TimeValuePair>)new Pair((Object)false, null));
                PartialPath p = ((MeasurementPath)seriesPaths.get(i)).transformToExactPath();
                restPaths.add(p);
                restDataType.add(dataTypes.get(i));
                continue;
            }
            if (!LastQueryExecutor.satisfyFilter(filter, tvPair)) {
                resultContainer.add((Pair<Boolean, TimeValuePair>)new Pair((Object)true, null));
                if (!debugOn) continue;
                DEBUG_LOGGER.info("[LastQueryExecutor] Last cache hit for path: {} with timestamp: {}", (Object)seriesPaths.get(i), (Object)tvPair.getTimestamp());
                continue;
            }
            resultContainer.add((Pair<Boolean, TimeValuePair>)new Pair((Object)true, (Object)tvPair));
            if (!debugOn) continue;
            DEBUG_LOGGER.info("[LastQueryExecutor] Last cache hit for path: {} with timestamp: {}", (Object)seriesPaths.get(i), (Object)tvPair.getTimestamp());
        }
        return resultContainer;
    }

    private static boolean satisfyFilter(Filter filter, TimeValuePair tvPair) {
        return filter == null || filter.satisfy(tvPair.getTimestamp(), tvPair.getValue().getValue());
    }

    public static void clear() {
        ID_TABLE_ENABLED = IoTDBDescriptor.getInstance().getConfig().isEnableIDTable();
    }

    static {
        logger = LoggerFactory.getLogger(LastQueryExecutor.class);
    }

    private static class IDTableLastCacheAccessor
    implements LastCacheAccessor {
        private PartialPath fullPath;

        IDTableLastCacheAccessor(PartialPath seriesPath) {
            this.fullPath = seriesPath;
        }

        @Override
        public TimeValuePair read() {
            try {
                IDTable table = StorageEngine.getInstance().getProcessor(this.fullPath.getDevicePath()).getIdTable();
                return table.getLastCache(new TimeseriesID(this.fullPath));
            }
            catch (StorageEngineException | MetadataException e) {
                logger.error("last query can't find storage group: path is: " + this.fullPath);
                return null;
            }
        }

        @Override
        public void write(TimeValuePair pair) {
            try {
                IDTable table = StorageEngine.getInstance().getProcessor(this.fullPath.getDevicePath()).getIdTable();
                table.updateLastCache(new TimeseriesID(this.fullPath), pair, false, Long.MIN_VALUE);
            }
            catch (StorageEngineException | MetadataException e) {
                logger.error("last query can't find storage group: path is: " + this.fullPath);
            }
        }
    }

    private static class MManagerLastCacheAccessor
    implements LastCacheAccessor {
        private final MeasurementPath path;
        private IMeasurementMNode node;

        MManagerLastCacheAccessor(PartialPath seriesPath) {
            this.path = (MeasurementPath)seriesPath;
        }

        @Override
        public TimeValuePair read() {
            block3: {
                try {
                    this.node = IoTDB.metaManager.getMeasurementMNode(this.path);
                }
                catch (MetadataException e) {
                    TimeValuePair timeValuePair = IoTDB.metaManager.getLastCache(this.path);
                    if (timeValuePair == null) break block3;
                    return timeValuePair;
                }
            }
            if (this.node == null) {
                return null;
            }
            return IoTDB.metaManager.getLastCache(this.node);
        }

        @Override
        public void write(TimeValuePair pair) {
            if (this.node == null) {
                IoTDB.metaManager.updateLastCache(this.path, pair, false, (Long)Long.MIN_VALUE);
            } else {
                IoTDB.metaManager.updateLastCache(this.node, pair, false, (Long)Long.MIN_VALUE);
            }
        }
    }

    private static interface LastCacheAccessor {
        public TimeValuePair read();

        public void write(TimeValuePair var1);
    }
}

