/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.datastructure;

import java.util.List;
import java.util.PriorityQueue;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.utils.MemUtils;
import org.apache.iotdb.db.utils.datastructure.BatchEncodeInfo;
import org.apache.iotdb.db.utils.datastructure.MultiTVListIterator;
import org.apache.iotdb.db.utils.datastructure.TVList;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.write.UnSupportedDataTypeException;
import org.apache.tsfile.write.chunk.ChunkWriterImpl;
import org.apache.tsfile.write.chunk.IChunkWriter;

public class MergeSortMultiTVListIterator
extends MultiTVListIterator {
    private final List<Integer> probeIterators;
    private final PriorityQueue<Pair<Long, Integer>> minHeap = new PriorityQueue((a, b) -> ((Long)a.left).equals(b.left) ? ((Integer)b.right).compareTo((Integer)a.right) : ((Long)a.left).compareTo((Long)b.left));
    private static final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();
    private final long TARGET_CHUNK_SIZE = CONFIG.getTargetChunkSize();
    private final long MAX_NUMBER_OF_POINTS_IN_CHUNK = CONFIG.getTargetChunkPointNum();

    public MergeSortMultiTVListIterator(TSDataType tsDataType, List<TVList> tvLists, List<TimeRange> deletionList, Integer floatPrecision, TSEncoding encoding) {
        super(tsDataType, tvLists, deletionList, floatPrecision, encoding);
        this.probeIterators = IntStream.range(0, this.tvListIterators.size()).boxed().collect(Collectors.toList());
    }

    @Override
    protected void prepareNext() {
        this.hasNext = false;
        for (int i : this.probeIterators) {
            TVList.TVListIterator iterator = (TVList.TVListIterator)this.tvListIterators.get(i);
            if (!iterator.hasNextTimeValuePair()) continue;
            this.minHeap.add((Pair<Long, Integer>)new Pair((Object)iterator.currentTime(), (Object)i));
        }
        this.probeIterators.clear();
        if (!this.minHeap.isEmpty()) {
            Pair<Long, Integer> top = this.minHeap.poll();
            this.currentTime = (Long)top.left;
            this.probeIterators.add((Integer)top.right);
            this.iteratorIndex = (Integer)top.right;
            this.rowIndex = ((TVList.TVListIterator)this.tvListIterators.get(this.iteratorIndex)).getIndex();
            this.hasNext = true;
            while (!this.minHeap.isEmpty() && (Long)this.minHeap.peek().left == this.currentTime) {
                Pair<Long, Integer> element = this.minHeap.poll();
                this.probeIterators.add((Integer)element.right);
            }
        }
        this.probeNext = true;
    }

    @Override
    protected void next() {
        for (int index : this.probeIterators) {
            ((TVList.TVListIterator)this.tvListIterators.get(index)).next();
        }
        this.probeNext = false;
    }

    @Override
    public void encodeBatch(IChunkWriter chunkWriter, BatchEncodeInfo encodeInfo, long[] times) {
        ChunkWriterImpl chunkWriterImpl = (ChunkWriterImpl)chunkWriter;
        while (this.hasNextTimeValuePair()) {
            TVList.TVListIterator currIterator = (TVList.TVListIterator)this.tvListIterators.get(this.iteratorIndex);
            int row = this.rowIndex;
            long time = this.currentTime;
            this.next();
            if (!this.hasNextTimeValuePair()) {
                chunkWriterImpl.setLastPoint(true);
            }
            switch (this.tsDataType) {
                case BOOLEAN: {
                    chunkWriterImpl.write(time, currIterator.getTVList().getBoolean(row));
                    encodeInfo.dataSizeInChunk += 9L;
                    break;
                }
                case INT32: 
                case DATE: {
                    chunkWriterImpl.write(time, currIterator.getTVList().getInt(row));
                    encodeInfo.dataSizeInChunk += 12L;
                    break;
                }
                case INT64: 
                case TIMESTAMP: {
                    chunkWriterImpl.write(time, currIterator.getTVList().getLong(row));
                    encodeInfo.dataSizeInChunk += 16L;
                    break;
                }
                case FLOAT: {
                    chunkWriterImpl.write(time, currIterator.getTVList().getFloat(row));
                    encodeInfo.dataSizeInChunk += 12L;
                    break;
                }
                case DOUBLE: {
                    chunkWriterImpl.write(time, currIterator.getTVList().getDouble(row));
                    encodeInfo.dataSizeInChunk += 16L;
                    break;
                }
                case TEXT: 
                case BLOB: 
                case STRING: {
                    Binary value = currIterator.getTVList().getBinary(row);
                    chunkWriterImpl.write(time, value);
                    encodeInfo.dataSizeInChunk += 8L + MemUtils.getBinarySize(value);
                    break;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", this.tsDataType));
                }
            }
            ++encodeInfo.pointNumInChunk;
            if ((long)encodeInfo.pointNumInChunk < this.MAX_NUMBER_OF_POINTS_IN_CHUNK && encodeInfo.dataSizeInChunk < this.TARGET_CHUNK_SIZE) continue;
            break;
        }
    }
}

