/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.core.type;

import io.micrometer.core.instrument.DistributionSummary;
import org.apache.iotdb.metrics.core.type.IoTDBHistogramMBean;
import org.apache.iotdb.metrics.core.type.IoTDBHistogramSnapshot;
import org.apache.iotdb.metrics.type.Histogram;
import org.apache.iotdb.metrics.type.HistogramSnapshot;
import org.apache.iotdb.metrics.utils.AbstractMetricMBean;

public class IoTDBHistogram
extends AbstractMetricMBean
implements Histogram,
IoTDBHistogramMBean {
    DistributionSummary distributionSummary;

    public IoTDBHistogram(DistributionSummary distributionSummary) {
        this.distributionSummary = distributionSummary;
    }

    @Override
    public double getMax() {
        return this.takeSnapshot().getMax();
    }

    @Override
    public double getMean() {
        return this.takeSnapshot().getMean();
    }

    @Override
    public int getSize() {
        return this.takeSnapshot().size();
    }

    @Override
    public double get50thPercentile() {
        return this.takeSnapshot().getValue(0.5);
    }

    @Override
    public double get99thPercentile() {
        return this.takeSnapshot().getValue(0.99);
    }

    public void update(long value) {
        this.distributionSummary.record((double)value);
    }

    @Override
    public long getCount() {
        return this.distributionSummary.count();
    }

    public HistogramSnapshot takeSnapshot() {
        return new IoTDBHistogramSnapshot(this.distributionSummary);
    }
}

