/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.agent.task.builder;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.consensus.SchemaRegionId;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.pipe.agent.task.PipeTask;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeMeta;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeRuntimeMeta;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeStaticMeta;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.pipe.agent.task.builder.PipeDataNodeTaskBuilder;
import org.apache.iotdb.db.pipe.source.dataregion.DataRegionListeningFilter;
import org.apache.iotdb.db.pipe.source.schemaregion.SchemaRegionListeningFilter;
import org.apache.iotdb.db.schemaengine.SchemaEngine;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;

public class PipeDataNodeBuilder {
    private static final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();
    private final PipeMeta pipeMeta;

    public PipeDataNodeBuilder(PipeMeta pipeMeta) {
        this.pipeMeta = pipeMeta;
    }

    public Map<Integer, PipeTask> buildTasksWithInternalSource() throws IllegalPathException {
        PipeStaticMeta pipeStaticMeta = this.pipeMeta.getStaticMeta();
        PipeRuntimeMeta pipeRuntimeMeta = this.pipeMeta.getRuntimeMeta();
        List<DataRegionId> dataRegionIds = StorageEngine.getInstance().getAllDataRegionIds();
        List<SchemaRegionId> schemaRegionIds = SchemaEngine.getInstance().getAllSchemaRegionIds();
        HashMap<Integer, PipeTask> consensusGroupIdToPipeTaskMap = new HashMap<Integer, PipeTask>();
        for (Map.Entry consensusGroupIdToPipeTaskMeta : pipeRuntimeMeta.getConsensusGroupId2TaskMetaMap().entrySet()) {
            boolean needConstructSchemaRegionTask;
            int consensusGroupId = (Integer)consensusGroupIdToPipeTaskMeta.getKey();
            PipeTaskMeta pipeTaskMeta = (PipeTaskMeta)consensusGroupIdToPipeTaskMeta.getValue();
            if (pipeTaskMeta.getLeaderNodeId() != CONFIG.getDataNodeId()) continue;
            PipeParameters extractorParameters = pipeStaticMeta.getExtractorParameters();
            DataRegionId dataRegionId = new DataRegionId(consensusGroupId);
            boolean needConstructDataRegionTask = dataRegionIds.contains(dataRegionId) && DataRegionListeningFilter.shouldDataRegionBeListened(extractorParameters, dataRegionId);
            boolean bl = needConstructSchemaRegionTask = schemaRegionIds.contains(new SchemaRegionId(consensusGroupId)) && SchemaRegionListeningFilter.shouldSchemaRegionBeListened(consensusGroupId, extractorParameters);
            if (!needConstructDataRegionTask && !needConstructSchemaRegionTask) continue;
            consensusGroupIdToPipeTaskMap.put(consensusGroupId, new PipeDataNodeTaskBuilder(pipeStaticMeta, consensusGroupId, pipeTaskMeta).build());
        }
        return consensusGroupIdToPipeTaskMap;
    }

    public Map<Integer, PipeTask> buildTasksWithExternalSource() {
        HashMap<Integer, PipeTask> taskIdToPipeTaskMap = new HashMap<Integer, PipeTask>();
        PipeStaticMeta pipeStaticMeta = this.pipeMeta.getStaticMeta();
        PipeRuntimeMeta pipeRuntimeMeta = this.pipeMeta.getRuntimeMeta();
        for (Map.Entry taskIdToPipeTaskMeta : pipeRuntimeMeta.getConsensusGroupId2TaskMetaMap().entrySet()) {
            int taskId = (Integer)taskIdToPipeTaskMeta.getKey();
            PipeTaskMeta pipeTaskMeta = (PipeTaskMeta)taskIdToPipeTaskMeta.getValue();
            if (pipeTaskMeta.getLeaderNodeId() != CONFIG.getDataNodeId()) continue;
            taskIdToPipeTaskMap.put(taskId, new PipeDataNodeTaskBuilder(pipeStaticMeta, taskId, pipeTaskMeta).build());
        }
        return taskIdToPipeTaskMap;
    }
}

