/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.auth.role;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.auth.entity.IEntityAccessor;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.auth.entity.PrivilegeUnion;
import org.apache.iotdb.commons.auth.entity.Role;
import org.apache.iotdb.commons.auth.role.IEntityManager;
import org.apache.iotdb.commons.concurrent.HashLock;
import org.apache.iotdb.commons.snapshot.SnapshotProcessor;
import org.apache.iotdb.commons.utils.AuthUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasicRoleManager
implements IEntityManager,
SnapshotProcessor {
    protected Map<String, Role> entityMap = new HashMap<String, Role>();
    protected IEntityAccessor accessor;
    protected HashLock lock;
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicRoleManager.class);

    protected TSStatusCode getEntityNotExistErrorCode() {
        return TSStatusCode.ROLE_NOT_EXIST;
    }

    protected String getNoSuchEntityError() {
        return "No such role %s";
    }

    protected BasicRoleManager() {
        this.lock = new HashLock();
    }

    protected BasicRoleManager(IEntityAccessor accessor) {
        this.accessor = accessor;
        this.lock = new HashLock();
        this.accessor.reset();
    }

    @Override
    public Role getEntity(String entityName) {
        this.lock.readLock(entityName);
        Role role = this.entityMap.get(entityName);
        this.lock.readUnlock(entityName);
        return role;
    }

    public boolean createRole(String entityName) {
        Role role = this.getEntity(entityName);
        if (role != null) {
            return false;
        }
        this.lock.writeLock(entityName);
        role = new Role(entityName);
        this.entityMap.put(entityName, role);
        this.lock.writeUnlock(entityName);
        return true;
    }

    @Override
    public boolean deleteEntity(String entityName) {
        this.lock.writeLock(entityName);
        boolean result = this.entityMap.remove(entityName) != null;
        this.lock.writeUnlock(entityName);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void grantPrivilegeToEntity(String entityName, PrivilegeUnion privilegeUnion) throws AuthException {
        this.lock.writeLock(entityName);
        try {
            Role role = this.getEntity(entityName);
            if (role == null) {
                throw new AuthException(this.getEntityNotExistErrorCode(), String.format(this.getNoSuchEntityError(), entityName));
            }
            switch (privilegeUnion.getModelType()) {
                case TREE: {
                    AuthUtils.validatePatternPath(privilegeUnion.getPath());
                    role.grantPathPrivilege(privilegeUnion.getPath(), privilegeUnion.getPrivilegeType(), privilegeUnion.isGrantOption());
                    return;
                }
                case SYSTEM: {
                    PrivilegeType type = privilegeUnion.getPrivilegeType();
                    role.grantSysPrivilege(type, privilegeUnion.isGrantOption());
                    return;
                }
                case RELATIONAL: {
                    if (privilegeUnion.isForAny()) {
                        role.grantAnyScopePrivilege(privilegeUnion.getPrivilegeType(), privilegeUnion.isGrantOption());
                        return;
                    } else if (privilegeUnion.getDBName() != null && privilegeUnion.getTbName() == null) {
                        role.grantDBPrivilege(privilegeUnion.getDBName(), privilegeUnion.getPrivilegeType(), privilegeUnion.isGrantOption());
                        return;
                    } else {
                        if (privilegeUnion.getDBName() == null || privilegeUnion.getTbName() == null) return;
                        role.grantTBPrivilege(privilegeUnion.getDBName(), privilegeUnion.getTbName(), privilegeUnion.getPrivilegeType(), privilegeUnion.isGrantOption());
                        return;
                    }
                }
                default: {
                    LOGGER.warn("Not support model type {}", (Object)privilegeUnion.getModelType());
                    return;
                }
            }
        }
        finally {
            this.lock.writeUnlock(entityName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revokePrivilegeFromEntity(String entityName, PrivilegeUnion privilegeUnion) throws AuthException {
        this.lock.writeLock(entityName);
        PrivilegeType privilegeType = privilegeUnion.getPrivilegeType();
        boolean isGrantOption = privilegeUnion.isGrantOption();
        boolean isAnyScope = privilegeUnion.isForAny();
        String dbName = privilegeUnion.getDBName();
        String tbName = privilegeUnion.getTbName();
        try {
            Role role = this.getEntity(entityName);
            if (role == null) {
                throw new AuthException(this.getEntityNotExistErrorCode(), String.format(this.getNoSuchEntityError(), entityName));
            }
            switch (privilegeUnion.getModelType()) {
                case TREE: {
                    if (isGrantOption) {
                        role.revokePathPrivilegeGrantOption(privilegeUnion.getPath(), privilegeType);
                        return;
                    }
                    role.revokePathPrivilege(privilegeUnion.getPath(), privilegeType);
                    return;
                }
                case RELATIONAL: {
                    if (isAnyScope) {
                        if (isGrantOption) {
                            role.revokeAnyScopePrivilegeGrantOption(privilegeType);
                            return;
                        }
                        role.revokeAnyScopePrivilege(privilegeType);
                        return;
                    }
                    if (privilegeUnion.getTbName() != null) {
                        if (isGrantOption) {
                            role.revokeTBPrivilegeGrantOption(dbName, tbName, privilegeType);
                            return;
                        }
                        role.revokeTBPrivilege(dbName, tbName, privilegeType);
                    } else {
                        if (isGrantOption) {
                            role.revokeDBPrivilegeGrantOption(dbName, privilegeType);
                            return;
                        }
                        role.revokeDBPrivilege(dbName, privilegeType);
                    }
                    return;
                }
                case SYSTEM: {
                    if (isGrantOption) {
                        role.revokeSysPrivilegeGrantOption(privilegeType);
                        return;
                    }
                    role.revokeSysPrivilege(privilegeType);
                    return;
                }
            }
            LOGGER.warn("Not support model type {}", (Object)privilegeUnion.getModelType());
        }
        finally {
            this.lock.writeUnlock(entityName);
        }
    }

    @Override
    public void reset() throws AuthException {
        this.accessor.reset();
        this.entityMap.clear();
        for (String entityName : this.accessor.listAllEntities()) {
            try {
                this.entityMap.put(entityName, this.accessor.loadEntity(entityName));
            }
            catch (IOException e) {
                LOGGER.warn("Get exception when load role {}", (Object)entityName);
                throw new AuthException(TSStatusCode.AUTH_IO_EXCEPTION, (Throwable)e);
            }
        }
    }

    @Override
    public List<String> listAllEntities() {
        ArrayList<String> rtlist = new ArrayList<String>();
        this.entityMap.forEach((name, item) -> rtlist.add((String)name));
        rtlist.sort(null);
        return rtlist;
    }
}

