/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.BitSet;
import java.util.Collection;
import java.util.Map;
import org.apache.jackrabbit.core.query.lucene.CommittableIndexReader;
import org.apache.jackrabbit.core.query.lucene.DocId;
import org.apache.jackrabbit.core.query.lucene.EmptyTermDocs;
import org.apache.jackrabbit.core.query.lucene.RefCountingIndexReader;
import org.apache.jackrabbit.core.query.lucene.SharedIndexReader;
import org.apache.lucene.index.FilterIndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermPositions;

class ReadOnlyIndexReader
extends RefCountingIndexReader {
    private BitSet deleted;
    private long deletedDocsVersion;

    public ReadOnlyIndexReader(SharedIndexReader reader, BitSet deleted, long deletedDocsVersion) {
        super(reader);
        this.deleted = deleted;
        this.deletedDocsVersion = deletedDocsVersion;
        reader.acquire();
    }

    long getDeletedDocsVersion() {
        return this.deletedDocsVersion;
    }

    long getCreationTick() {
        return this.getBase().getCreationTick();
    }

    void updateDeletedDocs(CommittableIndexReader reader) {
        Collection<Integer> deletes = reader.getDeletedSince(this.deletedDocsVersion);
        if (deletes == null) {
            this.deleted = reader.getDeletedDocs();
        } else {
            for (Integer d : deletes) {
                this.deleted.set(d);
            }
        }
        this.deletedDocsVersion = reader.getModificationCount();
    }

    public DocId getParent(int n) throws IOException {
        return this.getBase().getParent(n, this.deleted);
    }

    public SharedIndexReader getBase() {
        return (SharedIndexReader)this.in;
    }

    @Override
    public boolean isDeleted(int n) {
        return this.deleted.get(n);
    }

    @Override
    public boolean hasDeletions() {
        return !this.deleted.isEmpty();
    }

    @Override
    public int numDocs() {
        return this.maxDoc() - this.deleted.cardinality();
    }

    @Override
    protected final void doDelete(int docNum) {
        throw new UnsupportedOperationException("IndexReader is read-only");
    }

    @Override
    protected final void doUndeleteAll() {
        throw new UnsupportedOperationException("IndexReader is read-only");
    }

    @Override
    protected void doCommit(Map<String, String> commitUserData) throws IOException {
        if (!this.hasChanges) {
            return;
        }
        throw new UnsupportedOperationException("IndexReader is read-only");
    }

    @Override
    public TermDocs termDocs(Term term) throws IOException {
        TermDocs td = this.in.termDocs(term);
        if (td != EmptyTermDocs.INSTANCE) {
            td = new FilteredTermDocs(td);
        }
        return td;
    }

    @Override
    public TermDocs termDocs() throws IOException {
        return new FilteredTermDocs(super.termDocs());
    }

    @Override
    public TermPositions termPositions() throws IOException {
        return new FilteredTermPositions(super.termPositions());
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder("ReadOnlyIndexReader(");
        buffer.append(this.in);
        buffer.append(',');
        buffer.append(this.deletedDocsVersion);
        buffer.append(')');
        return buffer.toString();
    }

    private final class FilteredTermPositions
    extends FilteredTermDocs
    implements TermPositions {
        public FilteredTermPositions(TermPositions in) {
            super(in);
        }

        @Override
        public int nextPosition() throws IOException {
            return ((TermPositions)this.in).nextPosition();
        }

        @Override
        public int getPayloadLength() {
            return ((TermPositions)this.in).getPayloadLength();
        }

        @Override
        public byte[] getPayload(byte[] data, int offset) throws IOException {
            return ((TermPositions)this.in).getPayload(data, offset);
        }

        @Override
        public boolean isPayloadAvailable() {
            return ((TermPositions)this.in).isPayloadAvailable();
        }
    }

    private class FilteredTermDocs
    extends FilterIndexReader.FilterTermDocs {
        public FilteredTermDocs(TermDocs in) {
            super(in);
        }

        @Override
        public final boolean next() throws IOException {
            boolean hasNext = this.in.next();
            while (hasNext && ReadOnlyIndexReader.this.deleted.get(this.in.doc())) {
                hasNext = this.in.next();
            }
            return hasNext;
        }

        @Override
        public final int read(int[] docs, int[] freqs) throws IOException {
            int numDeleted;
            int num;
            do {
                if ((num = this.in.read(docs, freqs)) == 0) {
                    return 0;
                }
                numDeleted = 0;
                for (int i = 0; i < num; ++i) {
                    if (ReadOnlyIndexReader.this.deleted.get(docs[i])) {
                        ++numDeleted;
                        continue;
                    }
                    if (numDeleted <= 0) continue;
                    docs[i - numDeleted] = docs[i];
                    freqs[i - numDeleted] = freqs[i];
                }
            } while (num == numDeleted);
            return num - numDeleted;
        }

        @Override
        public final boolean skipTo(int i) throws IOException {
            boolean exists = this.in.skipTo(i);
            while (exists && ReadOnlyIndexReader.this.deleted.get(this.doc())) {
                exists = this.next();
            }
            return exists;
        }
    }
}

