/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene.directory;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import org.apache.jackrabbit.core.query.lucene.IOCounters;
import org.apache.jackrabbit.core.query.lucene.SearchIndex;
import org.apache.jackrabbit.core.query.lucene.directory.DirectoryManager;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NativeFSLockFactory;
import org.apache.lucene.store.SimpleFSDirectory;

public class FSDirectoryManager
implements DirectoryManager {
    private File baseDir;
    private boolean useSimpleFSDirectory;

    @Override
    public void init(SearchIndex handler) throws IOException {
        this.baseDir = new File(handler.getPath());
        this.useSimpleFSDirectory = handler.isUseSimpleFSDirectory();
    }

    @Override
    public boolean hasDirectory(String name) throws IOException {
        return new File(this.baseDir, name).exists();
    }

    @Override
    public Directory getDirectory(String name) throws IOException {
        File dir = name.equals(".") ? this.baseDir : new File(this.baseDir, name);
        return new FSDir(dir, this.useSimpleFSDirectory);
    }

    @Override
    public String[] getDirectoryNames() throws IOException {
        File[] dirs = this.baseDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        if (dirs != null) {
            String[] names = new String[dirs.length];
            for (int i = 0; i < dirs.length; ++i) {
                names[i] = dirs[i].getName();
            }
            return names;
        }
        throw new IOException("listFiles for " + this.baseDir.getPath() + " returned null");
    }

    @Override
    public boolean delete(String name) {
        File directory = new File(this.baseDir, name);
        if (!directory.exists()) {
            return true;
        }
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.delete()) continue;
                return false;
            }
        } else {
            return false;
        }
        return directory.delete();
    }

    @Override
    public boolean rename(String from, String to) {
        File src = new File(this.baseDir, from);
        File dest = new File(this.baseDir, to);
        return src.renameTo(dest);
    }

    @Override
    public void dispose() {
    }

    private static final class IndexInputLogWrapper
    extends IndexInput {
        private IndexInput in;

        IndexInputLogWrapper(String name, IndexInput in) {
            super(name);
            this.in = in;
        }

        @Override
        public byte readByte() throws IOException {
            return this.in.readByte();
        }

        @Override
        public void readBytes(byte[] b, int offset, int len) throws IOException {
            IOCounters.incrRead();
            this.in.readBytes(b, offset, len);
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }

        @Override
        public long getFilePointer() {
            return this.in.getFilePointer();
        }

        @Override
        public void seek(long pos) throws IOException {
            this.in.seek(pos);
        }

        @Override
        public long length() {
            return this.in.length();
        }

        @Override
        public Object clone() {
            IndexInputLogWrapper clone = (IndexInputLogWrapper)super.clone();
            clone.in = (IndexInput)this.in.clone();
            return clone;
        }
    }

    private static final class FSDir
    extends Directory {
        private static final FileFilter FILTER = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile();
            }
        };
        private final FSDirectory directory;

        public FSDir(File dir, boolean simpleFS) throws IOException {
            if (!dir.mkdirs() && !dir.isDirectory()) {
                throw new IOException("Unable to create directory: '" + String.valueOf(dir) + "'");
            }
            NativeFSLockFactory lockFactory = new NativeFSLockFactory(dir);
            this.directory = simpleFS ? new SimpleFSDirectory(dir, lockFactory) : FSDirectory.open(dir, lockFactory);
        }

        @Override
        public String[] listAll() throws IOException {
            File[] files = this.directory.getDirectory().listFiles(FILTER);
            if (files == null) {
                return null;
            }
            String[] names = new String[files.length];
            for (int i = 0; i < names.length; ++i) {
                names[i] = files[i].getName();
            }
            return names;
        }

        @Override
        public boolean fileExists(String name) throws IOException {
            return this.directory.fileExists(name);
        }

        @Override
        public long fileModified(String name) throws IOException {
            return this.directory.fileModified(name);
        }

        @Override
        public void touchFile(String name) throws IOException {
            this.directory.touchFile(name);
        }

        @Override
        public void deleteFile(String name) throws IOException {
            this.directory.deleteFile(name);
        }

        @Override
        public long fileLength(String name) throws IOException {
            return this.directory.fileLength(name);
        }

        @Override
        public IndexOutput createOutput(String name) throws IOException {
            return this.directory.createOutput(name);
        }

        @Override
        public IndexInput openInput(String name) throws IOException {
            IndexInput in = this.directory.openInput(name);
            return new IndexInputLogWrapper(name, in);
        }

        @Override
        public void close() throws IOException {
            this.directory.close();
        }

        @Override
        public IndexInput openInput(String name, int bufferSize) throws IOException {
            IndexInput in = this.directory.openInput(name, bufferSize);
            return new IndexInputLogWrapper(name, in);
        }

        @Override
        public Lock makeLock(String name) {
            return this.directory.makeLock(name);
        }

        @Override
        public void clearLock(String name) throws IOException {
            this.directory.clearLock(name);
        }

        @Override
        public void setLockFactory(LockFactory lockFactory) throws IOException {
            this.directory.setLockFactory(lockFactory);
        }

        @Override
        public LockFactory getLockFactory() {
            return this.directory.getLockFactory();
        }

        @Override
        public String getLockID() {
            return this.directory.getLockID();
        }

        @Override
        public String toString() {
            return this.getClass().getName() + "@" + String.valueOf(this.directory);
        }
    }
}

