/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.user;

import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.api.security.principal.ItemBasedPrincipal;
import org.apache.jackrabbit.api.security.user.Impersonation;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.PropertyImpl;
import org.apache.jackrabbit.core.security.authentication.CryptedSimpleCredentials;
import org.apache.jackrabbit.core.security.principal.AdminPrincipal;
import org.apache.jackrabbit.core.security.user.AuthorizableImpl;
import org.apache.jackrabbit.core.security.user.ImpersonationImpl;
import org.apache.jackrabbit.core.security.user.PasswordUtility;
import org.apache.jackrabbit.core.security.user.UserManagerImpl;

public class UserImpl
extends AuthorizableImpl
implements User {
    private Principal principal;
    private Impersonation impersonation;

    protected UserImpl(NodeImpl node, UserManagerImpl userManager) {
        super(node, userManager);
    }

    @Override
    public boolean isGroup() {
        return false;
    }

    @Override
    public Principal getPrincipal() throws RepositoryException {
        if (this.principal == null) {
            this.principal = this.isAdmin() ? new NodeBasedAdminPrincipal(this.getPrincipalName()) : new AuthorizableImpl.NodeBasedPrincipal(this.getPrincipalName());
        }
        return this.principal;
    }

    @Override
    public boolean isAdmin() {
        try {
            return this.userManager.isAdminId(this.getID());
        }
        catch (RepositoryException e) {
            log.error("Internal error while retrieving UserID.", e);
            return false;
        }
    }

    @Override
    public boolean isSystemUser() {
        return false;
    }

    @Override
    public Credentials getCredentials() throws RepositoryException {
        try {
            String password = this.getNode().getProperty(P_PASSWORD).getString();
            return new CryptedSimpleCredentials(this.getID(), password);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RepositoryException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RepositoryException(e);
        }
    }

    @Override
    public Impersonation getImpersonation() throws RepositoryException {
        if (this.impersonation == null) {
            this.impersonation = new ImpersonationImpl(this, this.userManager);
        }
        return this.impersonation;
    }

    @Override
    public void changePassword(String password) throws RepositoryException {
        this.userManager.onPasswordChange(this, password);
        this.userManager.setPassword(this.getNode(), password, true);
        if (this.userManager.isAutoSave()) {
            this.getNode().save();
        }
    }

    @Override
    public void changePassword(String password, String oldPassword) throws RepositoryException {
        String pwHash = this.getNode().getProperty(P_PASSWORD).getString();
        if (!PasswordUtility.isSame(pwHash, oldPassword)) {
            throw new RepositoryException("Failed to change password: Old password does not match.");
        }
        this.changePassword(password);
    }

    @Override
    public void disable(String reason) throws RepositoryException {
        if (this.isAdmin()) {
            throw new RepositoryException("The administrator user cannot be disabled.");
        }
        if (reason == null) {
            if (this.isDisabled()) {
                PropertyImpl disableProp = this.getNode().getProperty(P_DISABLED);
                this.userManager.removeProtectedItem(disableProp, this.getNode());
            }
        } else {
            Value v = this.getSession().getValueFactory().createValue(reason);
            this.userManager.setProtectedProperty(this.getNode(), P_DISABLED, v);
        }
    }

    @Override
    public boolean isDisabled() throws RepositoryException {
        return this.getNode().hasProperty(P_DISABLED);
    }

    @Override
    public String getDisabledReason() throws RepositoryException {
        if (this.isDisabled()) {
            return this.getNode().getProperty(P_DISABLED).getString();
        }
        return null;
    }

    private class NodeBasedAdminPrincipal
    extends AdminPrincipal
    implements ItemBasedPrincipal {
        public NodeBasedAdminPrincipal(String adminId) {
            super(adminId);
        }

        @Override
        public String getPath() throws RepositoryException {
            return UserImpl.this.getNode().getPath();
        }
    }
}

