/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.api.handler;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.james.protocols.api.handler.ExtensibleHandler;
import org.apache.james.protocols.api.handler.ProtocolHandler;
import org.apache.james.protocols.api.handler.ProtocolHandlerChain;
import org.apache.james.protocols.api.handler.WiringException;

public abstract class AbstractProtocolHandlerChain
implements ProtocolHandlerChain {
    protected abstract List<ProtocolHandler> getHandlers();

    @Override
    public <T> LinkedList<T> getHandlers(Class<T> type) {
        List<ProtocolHandler> handlers = this.getHandlers();
        return handlers.stream().filter(type::isInstance).map(handler -> handler).collect(Collectors.toCollection(LinkedList::new));
    }

    public void wireExtensibleHandlers() throws WiringException {
        List<ProtocolHandler> handlers = this.getHandlers();
        for (ProtocolHandler handler : handlers) {
            if (!(handler instanceof ExtensibleHandler)) continue;
            ExtensibleHandler extensibleHandler = (ExtensibleHandler)((Object)handler);
            List<Class<?>> markerInterfaces = extensibleHandler.getMarkerInterfaces();
            for (Class<?> markerInterface : markerInterfaces) {
                LinkedList<?> extensions = this.getHandlers(markerInterface);
                extensibleHandler.wireExtensions(markerInterface, extensions);
            }
        }
    }

    @Override
    public void destroy() {
        LinkedList<ProtocolHandler> handlers = this.getHandlers(ProtocolHandler.class);
        for (ProtocolHandler handler : handlers) {
            handler.destroy();
        }
    }
}

