/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jspf.terms;

import org.apache.james.jspf.core.DNSLookupContinuation;
import org.apache.james.jspf.core.IPAddr;
import org.apache.james.jspf.core.Inet6Util;
import org.apache.james.jspf.core.SPFSession;
import org.apache.james.jspf.core.exceptions.PermErrorException;
import org.apache.james.jspf.terms.Configuration;
import org.apache.james.jspf.terms.GenericMechanism;

public class IP4Mechanism
extends GenericMechanism {
    public static final String REGEX = "[iI][pP][4]\\:([0-9.]+)(?:/(\\d+))?";
    private IPAddr ip = null;

    public DNSLookupContinuation checkSPF(SPFSession spfData) throws PermErrorException {
        IPAddr originalIP = IPAddr.getAddress(spfData.getIpAddress(), this.getIp().getMaskLength());
        spfData.setAttribute("Mechanism.result", this.getIp().getMaskedIPAddress().equals(originalIP.getMaskedIPAddress()));
        return null;
    }

    public synchronized void config(Configuration params) throws PermErrorException {
        String maskLengthString;
        if (params.groupCount() == 0) {
            throw new PermErrorException("Missing ip");
        }
        String ipString = params.group(1);
        if (!this.isValidAddress(ipString)) {
            throw new PermErrorException("Invalid Address: " + ipString);
        }
        int maskLength = this.getMaxCidr();
        if (params.groupCount() >= 2 && params.group(2) != null && ((maskLength = Integer.parseInt(maskLengthString = params.group(2))) > this.getMaxCidr() || maskLengthString.length() > 1 && maskLengthString.startsWith("0"))) {
            throw new PermErrorException("Invalid CIDR: " + maskLengthString);
        }
        this.ip = IPAddr.getAddress(ipString, maskLength);
    }

    protected boolean isValidAddress(String ipString) {
        return Inet6Util.isValidIPV4Address(ipString);
    }

    protected int getMaxCidr() {
        return 32;
    }

    protected synchronized IPAddr getIp() {
        return this.ip;
    }

    public String toString() {
        if (this.getIp().getMaskLength() == this.getMaxCidr()) {
            return "ip4:" + this.getIp().getIPAddress();
        }
        return "ip4:" + this.getIp().getIPAddress() + "/" + this.getIp().getMaskLength();
    }
}

