/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.mail.model;

import com.google.common.base.MoreObjects;
import java.util.Objects;

public class Property {
    private final String namespace;
    private final String localName;
    private final String value;

    public Property(String namespace, String localName, String value) {
        this.namespace = namespace;
        this.localName = localName;
        this.value = value;
    }

    public Property(Property property) {
        this(property.getNamespace(), property.getLocalName(), property.getValue());
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isNamed(String namespace, String localName) {
        return namespace.equals(this.namespace) && localName.equals(this.localName);
    }

    public boolean isInSpace(String namespace) {
        return this.namespace.equals(namespace);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("namespace", (Object)this.namespace).add("localName", (Object)this.localName).add("value", (Object)this.value).toString();
    }

    public final boolean equals(Object o) {
        if (o instanceof Property) {
            Property that = (Property)o;
            return Objects.equals(this.namespace, that.namespace) && Objects.equals(this.localName, that.localName) && Objects.equals(this.value, that.value);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.namespace, this.localName, this.value);
    }
}

