/*
 * Decompiled with CFR 0.152.
 */
package org.awaitility;

import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import org.awaitility.Durations;
import org.awaitility.constraint.AtMostWaitConstraint;
import org.awaitility.constraint.WaitConstraint;
import org.awaitility.core.ConditionEvaluationListener;
import org.awaitility.core.ConditionFactory;
import org.awaitility.core.DurationFactory;
import org.awaitility.core.ExceptionIgnorer;
import org.awaitility.core.ExecutorLifecycle;
import org.awaitility.core.FailFastCondition;
import org.awaitility.core.FieldSupplierBuilder;
import org.awaitility.core.HamcrestExceptionIgnorer;
import org.awaitility.core.InternalExecutorServiceFactory;
import org.awaitility.core.PredicateExceptionIgnorer;
import org.awaitility.pollinterval.FixedPollInterval;
import org.awaitility.pollinterval.PollInterval;
import org.hamcrest.Matcher;

public class Awaitility {
    private static final Duration DEFAULT_POLL_DELAY = null;
    private static final PollInterval DEFAULT_POLL_INTERVAL;
    private static volatile PollInterval defaultPollInterval;
    private static volatile WaitConstraint defaultWaitConstraint;
    private static volatile Duration defaultPollDelay;
    private static volatile boolean defaultCatchUncaughtExceptions;
    private static volatile ExceptionIgnorer defaultExceptionIgnorer;
    private static volatile ConditionEvaluationListener defaultConditionEvaluationListener;
    private static volatile ExecutorLifecycle defaultExecutorLifecycle;
    private static volatile FailFastCondition defaultFailFastCondition;

    public static void catchUncaughtExceptionsByDefault() {
        defaultCatchUncaughtExceptions = true;
    }

    public static void doNotCatchUncaughtExceptionsByDefault() {
        defaultCatchUncaughtExceptions = false;
    }

    public static void ignoreExceptionsByDefault() {
        defaultExceptionIgnorer = new PredicateExceptionIgnorer(e -> true);
    }

    public static void ignoreExceptionByDefault(Class<? extends Throwable> exceptionType) {
        defaultExceptionIgnorer = new PredicateExceptionIgnorer(e -> e.getClass().equals(exceptionType));
    }

    public static void ignoreExceptionsByDefaultMatching(Predicate<? super Throwable> predicate) {
        defaultExceptionIgnorer = new PredicateExceptionIgnorer(predicate);
    }

    public static void ignoreExceptionsByDefaultMatching(Matcher<? super Throwable> matcher) {
        defaultExceptionIgnorer = new HamcrestExceptionIgnorer(matcher);
    }

    public static void pollInSameThread() {
        defaultExecutorLifecycle = ExecutorLifecycle.withNormalCleanupBehavior(InternalExecutorServiceFactory::sameThreadExecutorService);
    }

    public static void pollExecutorService(ExecutorService executorService) {
        defaultExecutorLifecycle = ExecutorLifecycle.withoutCleanup(executorService);
    }

    public static void pollThread(Function<Runnable, Thread> threadSupplier) {
        defaultExecutorLifecycle = ExecutorLifecycle.withNormalCleanupBehavior(() -> InternalExecutorServiceFactory.create(threadSupplier));
    }

    public static void reset() {
        defaultPollInterval = DEFAULT_POLL_INTERVAL;
        defaultPollDelay = DEFAULT_POLL_DELAY;
        defaultWaitConstraint = AtMostWaitConstraint.TEN_SECONDS;
        defaultCatchUncaughtExceptions = true;
        defaultConditionEvaluationListener = null;
        defaultExecutorLifecycle = null;
        defaultExceptionIgnorer = new PredicateExceptionIgnorer(e -> false);
        defaultFailFastCondition = null;
        Thread.setDefaultUncaughtExceptionHandler(null);
    }

    public static ConditionFactory await() {
        return Awaitility.await(null);
    }

    public static ConditionFactory await(String alias) {
        return new ConditionFactory(alias, defaultWaitConstraint, defaultPollInterval, defaultPollDelay, defaultCatchUncaughtExceptions, defaultExceptionIgnorer, defaultConditionEvaluationListener, defaultExecutorLifecycle, defaultFailFastCondition);
    }

    public static ConditionFactory catchUncaughtExceptions() {
        return new ConditionFactory(null, defaultWaitConstraint, defaultPollInterval, defaultPollDelay, defaultCatchUncaughtExceptions, defaultExceptionIgnorer, defaultConditionEvaluationListener, defaultExecutorLifecycle, defaultFailFastCondition);
    }

    public static ConditionFactory dontCatchUncaughtExceptions() {
        return new ConditionFactory(null, defaultWaitConstraint, defaultPollInterval, defaultPollDelay, false, defaultExceptionIgnorer, defaultConditionEvaluationListener, defaultExecutorLifecycle, defaultFailFastCondition);
    }

    public static ConditionFactory with() {
        return new ConditionFactory(null, defaultWaitConstraint, defaultPollInterval, defaultPollDelay, defaultCatchUncaughtExceptions, defaultExceptionIgnorer, defaultConditionEvaluationListener, defaultExecutorLifecycle, defaultFailFastCondition);
    }

    public static ConditionFactory given() {
        return new ConditionFactory(null, defaultWaitConstraint, defaultPollInterval, defaultPollDelay, defaultCatchUncaughtExceptions, defaultExceptionIgnorer, defaultConditionEvaluationListener, defaultExecutorLifecycle, defaultFailFastCondition);
    }

    public static ConditionFactory waitAtMost(Duration timeout) {
        return new ConditionFactory(null, defaultWaitConstraint.withMaxWaitTime(timeout), defaultPollInterval, defaultPollDelay, defaultCatchUncaughtExceptions, defaultExceptionIgnorer, defaultConditionEvaluationListener, defaultExecutorLifecycle, defaultFailFastCondition);
    }

    public static ConditionFactory waitAtMost(long value, TimeUnit unit) {
        return new ConditionFactory(null, defaultWaitConstraint.withMaxWaitTime(DurationFactory.of(value, unit)), defaultPollInterval, defaultPollDelay, defaultCatchUncaughtExceptions, defaultExceptionIgnorer, defaultConditionEvaluationListener, defaultExecutorLifecycle, defaultFailFastCondition);
    }

    public static void setDefaultPollInterval(long pollInterval, TimeUnit unit) {
        defaultPollInterval = new FixedPollInterval(DurationFactory.of(pollInterval, unit));
    }

    public static void setDefaultPollDelay(long pollDelay, TimeUnit unit) {
        defaultPollDelay = DurationFactory.of(pollDelay, unit);
    }

    public static void setDefaultTimeout(long timeout, TimeUnit unit) {
        defaultWaitConstraint = defaultWaitConstraint.withMaxWaitTime(DurationFactory.of(timeout, unit));
    }

    public static void setDefaultPollInterval(Duration pollInterval) {
        if (pollInterval == null) {
            throw new IllegalArgumentException("You must specify a poll interval (was null).");
        }
        defaultPollInterval = new FixedPollInterval(pollInterval);
    }

    public static void setDefaultPollInterval(PollInterval pollInterval) {
        if (pollInterval == null) {
            throw new IllegalArgumentException("You must specify a poll interval (was null).");
        }
        defaultPollInterval = pollInterval;
    }

    public static void setDefaultPollDelay(Duration pollDelay) {
        if (pollDelay == null) {
            throw new IllegalArgumentException("You must specify a poll delay (was null).");
        }
        defaultPollDelay = pollDelay;
    }

    public static void setDefaultTimeout(Duration defaultTimeout) {
        if (defaultTimeout == null) {
            throw new IllegalArgumentException("You must specify a default timeout (was null).");
        }
        defaultWaitConstraint = defaultWaitConstraint.withMaxWaitTime(defaultTimeout);
    }

    public static void setDefaultConditionEvaluationListener(ConditionEvaluationListener defaultConditionEvaluationListener) {
        Awaitility.defaultConditionEvaluationListener = defaultConditionEvaluationListener;
    }

    public static void setDefaultFailFastCondition(Callable<Boolean> defaultFailFastCondition) {
        Awaitility.defaultFailFastCondition = new FailFastCondition(null, defaultFailFastCondition);
    }

    public static void setDefaultFailFastCondition(String failFastFailureReason, Callable<Boolean> defaultFailFastCondition) {
        Awaitility.defaultFailFastCondition = new FailFastCondition(failFastFailureReason, defaultFailFastCondition);
    }

    public static FieldSupplierBuilder fieldIn(Object object) {
        return new FieldSupplierBuilder(object);
    }

    public static FieldSupplierBuilder fieldIn(Class<?> clazz) {
        return new FieldSupplierBuilder(clazz);
    }

    static {
        defaultPollInterval = DEFAULT_POLL_INTERVAL = new FixedPollInterval(Durations.ONE_HUNDRED_MILLISECONDS);
        defaultWaitConstraint = AtMostWaitConstraint.TEN_SECONDS;
        defaultPollDelay = DEFAULT_POLL_DELAY;
        defaultCatchUncaughtExceptions = true;
        defaultExceptionIgnorer = new PredicateExceptionIgnorer(e -> false);
        defaultConditionEvaluationListener = null;
        defaultExecutorLifecycle = null;
        defaultFailFastCondition = null;
    }
}

