/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec.extras.array;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.extras.array.AbstractPrimitiveListToArrayCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.ByteBuffer;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public class ByteListToArrayCodec
extends AbstractPrimitiveListToArrayCodec<byte[]> {
    public ByteListToArrayCodec() {
        super(DataTypes.listOf(DataTypes.SMALLINT), GenericType.of(byte[].class));
    }

    @Override
    public boolean accepts(@NonNull Class<?> javaClass) {
        Objects.requireNonNull(javaClass);
        return byte[].class.equals(javaClass);
    }

    @Override
    public boolean accepts(@NonNull Object value) {
        Objects.requireNonNull(value);
        return value instanceof byte[];
    }

    @Override
    protected int sizeOfComponentType() {
        return 1;
    }

    @Override
    protected void serializeElement(@NonNull ByteBuffer output, @NonNull byte[] array, int index, @NonNull ProtocolVersion protocolVersion) {
        output.put(array[index]);
    }

    @Override
    protected void deserializeElement(@NonNull ByteBuffer input, @NonNull byte[] array, int index, @NonNull ProtocolVersion protocolVersion) {
        array[index] = input.get();
    }

    @Override
    protected void formatElement(@NonNull StringBuilder output, @NonNull byte[] array, int index) {
        output.append(array[index]);
    }

    @Override
    protected void parseElement(@NonNull String input, @NonNull byte[] array, int index) {
        array[index] = Byte.parseByte(input);
    }

    @Override
    @NonNull
    protected byte[] newInstance(int size) {
        return new byte[size];
    }
}

