/*
 * Decompiled with CFR 0.152.
 */
package com.linagora.logback.elasticsearch;

import ch.qos.logback.core.UnsynchronizedAppenderBase;
import com.linagora.logback.elasticsearch.AbstractElasticsearchPublisher;
import com.linagora.logback.elasticsearch.config.Authentication;
import com.linagora.logback.elasticsearch.config.ElasticsearchProperties;
import com.linagora.logback.elasticsearch.config.HttpRequestHeaders;
import com.linagora.logback.elasticsearch.config.Settings;
import com.linagora.logback.elasticsearch.util.ErrorReporter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public abstract class AbstractElasticsearchAppender<T>
extends UnsynchronizedAppenderBase<T> {
    protected Settings settings;
    protected ElasticsearchProperties elasticsearchProperties;
    protected AbstractElasticsearchPublisher<T> publisher;
    protected ErrorReporter errorReporter;
    protected HttpRequestHeaders headers;

    public AbstractElasticsearchAppender() {
        this.settings = new Settings();
        this.headers = new HttpRequestHeaders();
    }

    public AbstractElasticsearchAppender(Settings settings) {
        this.settings = settings;
    }

    public void start() {
        super.start();
        this.errorReporter = this.getErrorReporter();
        try {
            this.publisher = this.buildElasticsearchPublisher();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void publishEvent(T eventObject) {
        this.publisher.addEvent(eventObject);
    }

    protected ErrorReporter getErrorReporter() {
        return new ErrorReporter(this.settings, this.getContext());
    }

    protected abstract AbstractElasticsearchPublisher<T> buildElasticsearchPublisher() throws IOException;

    public void stop() {
        super.stop();
    }

    protected void append(T eventObject) {
        this.appendInternal(eventObject);
    }

    protected abstract void appendInternal(T var1);

    public void setProperties(ElasticsearchProperties elasticsearchProperties) {
        this.elasticsearchProperties = elasticsearchProperties;
    }

    public void setSleepTime(int sleepTime) {
        this.settings.setSleepTime(sleepTime);
    }

    public void setMaxRetries(int maxRetries) {
        this.settings.setMaxRetries(maxRetries);
    }

    public void setConnectTimeout(int connectTimeout) {
        this.settings.setConnectTimeout(connectTimeout);
    }

    public void setReadTimeout(int readTimeout) {
        this.settings.setReadTimeout(readTimeout);
    }

    public void setIncludeCallerData(boolean includeCallerData) {
        this.settings.setIncludeCallerData(includeCallerData);
    }

    public void setErrorsToStderr(boolean errorsToStderr) {
        this.settings.setErrorsToStderr(errorsToStderr);
    }

    public void setLogsToStderr(boolean logsToStderr) {
        this.settings.setLogsToStderr(logsToStderr);
    }

    public void setMaxQueueSize(int maxQueueSize) {
        this.settings.setMaxQueueSize(maxQueueSize);
    }

    public void setIndex(String index) {
        this.settings.setIndex(index);
    }

    public void setType(String type) {
        this.settings.setType(type);
    }

    public void setUrl(String url) throws MalformedURLException {
        this.settings.setUrl(new URL(url));
    }

    public void setLoggerName(String logger) {
        this.settings.setLoggerName(logger);
    }

    public void setErrorLoggerName(String logger) {
        this.settings.setErrorLoggerName(logger);
    }

    public void setHeaders(HttpRequestHeaders httpRequestHeaders) {
        this.headers = httpRequestHeaders;
    }

    public void setRawJsonMessage(boolean rawJsonMessage) {
        this.settings.setRawJsonMessage(rawJsonMessage);
    }

    public void setIncludeMdc(boolean includeMdc) {
        this.settings.setIncludeMdc(includeMdc);
    }

    public void setExcludedMdcKeys(String setExcludedMdcKeys) {
        this.settings.setExcludedMdcKeys(setExcludedMdcKeys);
    }

    public void setAuthentication(Authentication auth) {
        this.settings.setAuthentication(auth);
    }

    public void setMaxMessageSize(int maxMessageSize) {
        this.settings.setMaxMessageSize(maxMessageSize);
    }
}

