/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.task.eventsourcing.distributed;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Delivery;
import java.io.Closeable;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.james.backends.rabbitmq.QueueArguments;
import org.apache.james.backends.rabbitmq.RabbitMQConfiguration;
import org.apache.james.backends.rabbitmq.ReceiverProvider;
import org.apache.james.eventsourcing.Event;
import org.apache.james.eventsourcing.eventstore.cassandra.JsonEventSerializer;
import org.apache.james.lifecycle.api.Startable;
import org.apache.james.task.eventsourcing.TerminationSubscriber;
import org.apache.james.task.eventsourcing.distributed.TerminationQueueName;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Sinks;
import reactor.core.scheduler.Schedulers;
import reactor.rabbitmq.BindingSpecification;
import reactor.rabbitmq.ExchangeSpecification;
import reactor.rabbitmq.OutboundMessage;
import reactor.rabbitmq.QueueSpecification;
import reactor.rabbitmq.Receiver;
import reactor.rabbitmq.Sender;

public class RabbitMQTerminationSubscriber
implements TerminationSubscriber,
Startable,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(RabbitMQTerminationSubscriber.class);
    static final String EXCHANGE_NAME = "terminationSubscriberExchange";
    static final String QUEUE_NAME_PREFIX = "terminationSubscriber";
    static final String ROUTING_KEY = "terminationSubscriberRoutingKey";
    private final TerminationQueueName queueName;
    private final JsonEventSerializer serializer;
    private final Sender sender;
    private final ReceiverProvider receiverProvider;
    private final RabbitMQConfiguration rabbitMQConfiguration;
    private Sinks.Many<OutboundMessage> sendQueue;
    private Sinks.Many<Event> listener;
    private Disposable sendQueueHandle;
    private Disposable listenQueueHandle;

    @Inject
    RabbitMQTerminationSubscriber(TerminationQueueName queueName, Sender sender, ReceiverProvider receiverProvider, JsonEventSerializer serializer, RabbitMQConfiguration rabbitMQConfiguration) {
        this.queueName = queueName;
        this.sender = sender;
        this.receiverProvider = receiverProvider;
        this.serializer = serializer;
        this.rabbitMQConfiguration = rabbitMQConfiguration;
    }

    public void start() {
        this.sender.declareExchange(ExchangeSpecification.exchange((String)EXCHANGE_NAME)).block();
        QueueArguments.Builder builder = QueueArguments.builder();
        this.rabbitMQConfiguration.getQueueTTL().ifPresent(arg_0 -> ((QueueArguments.Builder)builder).queueTTL(arg_0));
        this.sender.declare(QueueSpecification.queue((String)this.queueName.asString()).durable(false).autoDelete(false).arguments((Map)builder.build())).block();
        this.sender.bind(BindingSpecification.binding((String)EXCHANGE_NAME, (String)ROUTING_KEY, (String)this.queueName.asString())).block();
        this.sendQueue = Sinks.many().unicast().onBackpressureBuffer();
        this.sendQueueHandle = this.sender.send((Publisher)this.sendQueue.asFlux()).subscribeOn(Schedulers.boundedElastic()).subscribe();
        this.listener = Sinks.many().multicast().directBestEffort();
        this.listenQueueHandle = this.consumeTerminationQueue();
    }

    public void restart() {
        Disposable previousHandler = this.listenQueueHandle;
        this.listenQueueHandle = this.consumeTerminationQueue();
        previousHandler.dispose();
    }

    private Disposable consumeTerminationQueue() {
        return Flux.using(() -> ((ReceiverProvider)this.receiverProvider).createReceiver(), receiver -> receiver.consumeAutoAck(this.queueName.asString()), Receiver::close).subscribeOn(Schedulers.boundedElastic()).map(this::toEvent).handle(ReactorUtils.publishIfPresent()).subscribe(e -> this.listener.emitNext(e, Sinks.EmitFailureHandler.FAIL_FAST));
    }

    public void addEvent(Event event) {
        try {
            byte[] payload = this.serializer.serialize(event).getBytes(StandardCharsets.UTF_8);
            AMQP.BasicProperties basicProperties = new AMQP.BasicProperties.Builder().build();
            OutboundMessage message = new OutboundMessage(EXCHANGE_NAME, ROUTING_KEY, basicProperties, payload);
            this.sendQueue.emitNext((Object)message, Sinks.EmitFailureHandler.FAIL_FAST);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public Publisher<Event> listenEvents() {
        return this.listener.asFlux();
    }

    private Optional<Event> toEvent(Delivery delivery) {
        String message = new String(delivery.getBody(), StandardCharsets.UTF_8);
        try {
            Event event = this.serializer.deserialize(message);
            return Optional.of(event);
        }
        catch (Exception e) {
            LOGGER.error("Unable to deserialize '{}'", (Object)message, (Object)e);
            return Optional.empty();
        }
    }

    @Override
    @PreDestroy
    public void close() {
        Optional.ofNullable(this.sendQueueHandle).ifPresent(Disposable::dispose);
        Optional.ofNullable(this.listenQueueHandle).ifPresent(Disposable::dispose);
    }
}

