/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailetcontainer.impl;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import jakarta.inject.Inject;
import jakarta.mail.internet.ParseException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.core.Username;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.mailetcontainer.api.LocalResources;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.lib.Mapping;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalResourcesImpl
implements LocalResources {
    private static final EnumSet<Mapping.Type> ALIAS_TYPES = EnumSet.of(Mapping.Type.Alias, Mapping.Type.DomainAlias);
    public static final Logger LOGGER = LoggerFactory.getLogger(LocalResourcesImpl.class);
    private final UsersRepository localUsers;
    private final DomainList domains;
    private final RecipientRewriteTable recipientRewriteTable;

    @Inject
    public LocalResourcesImpl(UsersRepository localUsers, DomainList domains, RecipientRewriteTable recipientRewriteTable) {
        this.localUsers = localUsers;
        this.domains = domains;
        this.recipientRewriteTable = recipientRewriteTable;
    }

    public boolean isLocalServer(Domain domain) {
        try {
            return this.domains.containsDomain(domain);
        }
        catch (DomainListException e) {
            throw new RuntimeException("Unable to retrieve domains", e);
        }
    }

    public boolean isLocalUser(String name) {
        if (name == null) {
            return false;
        }
        try {
            MailAddress mailAddress = Username.of((String)name).withDefaultDomain(this.domains.getDefaultDomain()).asMailAddress();
            return this.isLocalEmail(mailAddress);
        }
        catch (DomainListException e) {
            throw new RuntimeException("Unable to retrieve domains", e);
        }
        catch (ParseException e) {
            throw new RuntimeException("Unable to parse mail address", e);
        }
    }

    public boolean isLocalEmail(MailAddress mailAddress) {
        if (mailAddress != null) {
            if (!this.isLocalServer(mailAddress.getDomain())) {
                return false;
            }
            return this.belongsToALocalUser(mailAddress);
        }
        return false;
    }

    private boolean belongsToALocalUser(MailAddress mailAddress) {
        try {
            return this.isLocaluser(mailAddress) || this.isLocalAlias(mailAddress);
        }
        catch (UsersRepositoryException e) {
            throw new RuntimeException("Unable to retrieve users", e);
        }
        catch (RecipientRewriteTable.ErrorMappingException | RecipientRewriteTableException e) {
            throw new RuntimeException("Unable to retrieve RRTs", e);
        }
    }

    public Collection<MailAddress> localEmails(Collection<MailAddress> mailAddresses) {
        return (Collection)this.addressByDomains(mailAddresses).flatMap(this::hasLocalDomain).filter(this::belongsToALocalUser).collect(ImmutableList.toImmutableList());
    }

    private Stream<MailAddress> hasLocalDomain(Map.Entry<Domain, Collection<MailAddress>> entry) {
        if (this.isLocalServer(entry.getKey())) {
            return entry.getValue().stream();
        }
        return Stream.empty();
    }

    private Stream<Map.Entry<Domain, Collection<MailAddress>>> addressByDomains(Collection<MailAddress> mailAddresses) {
        return ((ImmutableListMultimap)mailAddresses.stream().collect(ImmutableListMultimap.toImmutableListMultimap(MailAddress::getDomain, Function.identity()))).asMap().entrySet().stream();
    }

    private boolean isLocaluser(MailAddress mailAddress) throws UsersRepositoryException {
        return this.localUsers.contains(this.localUsers.getUsername(mailAddress));
    }

    private boolean isLocalAlias(MailAddress mailAddress) throws UsersRepositoryException, RecipientRewriteTable.ErrorMappingException, RecipientRewriteTableException {
        return this.recipientRewriteTable.getResolvedMappings(mailAddress.getLocalPart(), mailAddress.getDomain(), ALIAS_TYPES).asStream().map(mapping -> (MailAddress)mapping.asMailAddress().orElseThrow(() -> new IllegalStateException(String.format("Can not compute address for mapping %s", mapping.asString())))).filter(Throwing.predicate(this::isLocaluser).sneakyThrow()).peek(ownerAddress -> LOGGER.debug("{} belongs to {} local user", (Object)mailAddress.asString(), (Object)ownerAddress.asString())).findFirst().isPresent();
    }
}

