/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Enumerated;
import com.unboundid.asn1.ASN1Integer;
import com.unboundid.asn1.ASN1Long;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.ldap.sdk.unboundidds.controls.TransactionSettingsBackendLockBehavior;
import com.unboundid.ldap.sdk.unboundidds.controls.TransactionSettingsCommitDurability;
import com.unboundid.ldap.sdk.unboundidds.controls.TransactionSettingsReqeustControlProperties;
import com.unboundid.ldap.sdk.unboundidds.controls.TransactionSettingsScopedLockDetails;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class TransactionSettingsRequestControl
extends Control {
    @NotNull
    public static final String TRANSACTION_SETTINGS_REQUEST_OID = "1.3.6.1.4.1.30221.2.5.38";
    private static final byte TYPE_TXN_NAME = -128;
    private static final byte TYPE_COMMIT_DURABILITY = -127;
    private static final byte TYPE_BACKEND_EXCLUSIVE_LOCK_BEHAVIOR = -126;
    private static final byte TYPE_BACKEND_LOCK_TIMEOUT = -125;
    private static final byte TYPE_RETRY_ATTEMPTS = -124;
    private static final byte TYPE_TXN_LOCK_TIMEOUT = -91;
    private static final byte TYPE_REPLICATE_CONTROL = -117;
    private static final byte TYPE_RETURN_RESPONSE_CONTROL = -122;
    private static final byte TYPE_SINGLE_WRITER_LOCK_BEHAVIOR = -121;
    static final byte TYPE_SCOPED_LOCK_DETAILS = -88;
    private static final long serialVersionUID = -4749344077745581287L;
    private final boolean replicateControl;
    private final boolean returnResponseControl;
    @Nullable
    private final Integer retryAttempts;
    @Nullable
    private final Long backendLockTimeoutMillis;
    @Nullable
    private final Long maxTxnLockTimeoutMillis;
    @Nullable
    private final Long minTxnLockTimeoutMillis;
    @Nullable
    private final String transactionName;
    @Nullable
    private final TransactionSettingsBackendLockBehavior backendExclusiveLockBehavior;
    @Nullable
    private final TransactionSettingsBackendLockBehavior singleWriterLockBehavior;
    @Nullable
    private final TransactionSettingsCommitDurability commitDurability;
    @Nullable
    private final TransactionSettingsScopedLockDetails scopedLockDetails;

    public TransactionSettingsRequestControl(boolean isCritical, @Nullable String transactionName, @Nullable TransactionSettingsCommitDurability commitDurability, @Nullable TransactionSettingsBackendLockBehavior backendLockBehavior, @Nullable Long backendLockTimeoutMillis, @Nullable Integer retryAttempts, @Nullable Long minTxnLockTimeoutMillis, @Nullable Long maxTxnLockTimeoutMillis) {
        this(isCritical, transactionName, commitDurability, backendLockBehavior, backendLockTimeoutMillis, retryAttempts, minTxnLockTimeoutMillis, maxTxnLockTimeoutMillis, false);
    }

    public TransactionSettingsRequestControl(boolean isCritical, @Nullable String transactionName, @Nullable TransactionSettingsCommitDurability commitDurability, @Nullable TransactionSettingsBackendLockBehavior backendLockBehavior, @Nullable Long backendLockTimeoutMillis, @Nullable Integer retryAttempts, @Nullable Long minTxnLockTimeoutMillis, @Nullable Long maxTxnLockTimeoutMillis, boolean returnResponseControl) {
        super(TRANSACTION_SETTINGS_REQUEST_OID, isCritical, TransactionSettingsRequestControl.encodeValue(transactionName, commitDurability, backendLockBehavior, null, null, backendLockTimeoutMillis, retryAttempts, minTxnLockTimeoutMillis, maxTxnLockTimeoutMillis, false, returnResponseControl));
        this.transactionName = transactionName;
        this.commitDurability = commitDurability;
        this.backendExclusiveLockBehavior = backendLockBehavior;
        this.backendLockTimeoutMillis = backendLockTimeoutMillis;
        this.minTxnLockTimeoutMillis = minTxnLockTimeoutMillis;
        this.maxTxnLockTimeoutMillis = maxTxnLockTimeoutMillis;
        this.retryAttempts = retryAttempts;
        this.returnResponseControl = returnResponseControl;
        this.singleWriterLockBehavior = null;
        this.scopedLockDetails = null;
        this.replicateControl = false;
    }

    public TransactionSettingsRequestControl(boolean isCritical, @NotNull TransactionSettingsReqeustControlProperties properties) {
        super(TRANSACTION_SETTINGS_REQUEST_OID, isCritical, TransactionSettingsRequestControl.encodeValue(properties.getTransactionName(), properties.getCommitDurability(), properties.getBackendExclusiveLockBehavior(), properties.getSingleWriterLockBehavior(), properties.getScopedLockDetails(), properties.getBackendLockTimeoutMillis(), properties.getRetryAttempts(), properties.getMinTxnLockTimeoutMillis(), properties.getMaxTxnLockTimeoutMillis(), properties.replicateControl(), properties.getReturnResponseControl()));
        this.transactionName = properties.getTransactionName();
        this.commitDurability = properties.getCommitDurability();
        this.backendExclusiveLockBehavior = properties.getBackendExclusiveLockBehavior();
        this.singleWriterLockBehavior = properties.getSingleWriterLockBehavior();
        this.scopedLockDetails = properties.getScopedLockDetails();
        this.backendLockTimeoutMillis = properties.getBackendLockTimeoutMillis();
        this.minTxnLockTimeoutMillis = properties.getMinTxnLockTimeoutMillis();
        this.maxTxnLockTimeoutMillis = properties.getMaxTxnLockTimeoutMillis();
        this.retryAttempts = properties.getRetryAttempts();
        this.replicateControl = properties.replicateControl();
        this.returnResponseControl = properties.getReturnResponseControl();
    }

    public TransactionSettingsRequestControl(@NotNull Control c) throws LDAPException {
        super(c);
        ASN1OctetString value = c.getValue();
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_TXN_SETTINGS_REQUEST_MISSING_VALUE.get());
        }
        try {
            boolean replicate = false;
            boolean responseControl = false;
            Integer numRetries = null;
            Long backendTimeout = null;
            Long maxTxnLockTimeout = null;
            Long minTxnLockTimeout = null;
            String txnName = null;
            TransactionSettingsBackendLockBehavior exclusiveLockBehavior = null;
            TransactionSettingsBackendLockBehavior swLockBehavior = null;
            TransactionSettingsCommitDurability durability = null;
            TransactionSettingsScopedLockDetails scopeDetails = null;
            block15: for (ASN1Element e : ASN1Sequence.decodeAsSequence(value.getValue()).elements()) {
                switch (e.getType()) {
                    case -128: {
                        txnName = ASN1OctetString.decodeAsOctetString(e).stringValue();
                        continue block15;
                    }
                    case -127: {
                        durability = TransactionSettingsCommitDurability.valueOf(ASN1Enumerated.decodeAsEnumerated(e).intValue());
                        if (durability != null) continue block15;
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_TXN_SETTINGS_REQUEST_UNKNOWN_DURABILITY.get(ASN1Enumerated.decodeAsEnumerated(e).intValue()));
                    }
                    case -126: {
                        exclusiveLockBehavior = TransactionSettingsBackendLockBehavior.valueOf(ASN1Enumerated.decodeAsEnumerated(e).intValue());
                        if (exclusiveLockBehavior != null) continue block15;
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_TXN_SETTINGS_REQUEST_UNKNOWN_EXCLUSIVE_LOCK_BEHAVIOR.get(ASN1Enumerated.decodeAsEnumerated(e).intValue()));
                    }
                    case -125: {
                        backendTimeout = ASN1Long.decodeAsLong(e).longValue();
                        if (backendTimeout >= 0L) continue block15;
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_TXN_SETTINGS_REQUEST_INVALID_BACKEND_LOCK_TIMEOUT.get(backendTimeout));
                    }
                    case -124: {
                        numRetries = ASN1Integer.decodeAsInteger(e).intValue();
                        if (numRetries >= 0) continue block15;
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_TXN_SETTINGS_REQUEST_INVALID_RETRY_ATTEMPTS.get(numRetries));
                    }
                    case -91: {
                        ASN1Element[] timeoutElements = ASN1Sequence.decodeAsSequence(e).elements();
                        minTxnLockTimeout = ASN1Long.decodeAsLong(timeoutElements[0]).longValue();
                        maxTxnLockTimeout = ASN1Long.decodeAsLong(timeoutElements[1]).longValue();
                        if (minTxnLockTimeout < 0L) {
                            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_TXN_SETTINGS_REQUEST_INVALID_MIN_TXN_LOCK_TIMEOUT.get(minTxnLockTimeout));
                        }
                        if (maxTxnLockTimeout >= minTxnLockTimeout) continue block15;
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_TXN_SETTINGS_REQUEST_INVALID_MAX_TXN_LOCK_TIMEOUT.get(maxTxnLockTimeout, minTxnLockTimeout));
                    }
                    case -121: {
                        swLockBehavior = TransactionSettingsBackendLockBehavior.valueOf(ASN1Enumerated.decodeAsEnumerated(e).intValue());
                        if (swLockBehavior != null) continue block15;
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_TXN_SETTINGS_REQUEST_UNKNOWN_SW_LOCK_BEHAVIOR.get(ASN1Enumerated.decodeAsEnumerated(e).intValue()));
                    }
                    case -88: {
                        scopeDetails = TransactionSettingsScopedLockDetails.decode(e);
                        continue block15;
                    }
                    case -117: {
                        replicate = ASN1Boolean.decodeAsBoolean(e).booleanValue();
                        continue block15;
                    }
                    case -122: {
                        responseControl = ASN1Boolean.decodeAsBoolean(e).booleanValue();
                        continue block15;
                    }
                    default: {
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_TXN_SETTINGS_REQUEST_UNRECOGNIZED_ELEMENT_TYPE.get(StaticUtils.toHex(e.getType())));
                    }
                }
            }
            this.transactionName = txnName;
            this.commitDurability = durability;
            this.backendExclusiveLockBehavior = exclusiveLockBehavior;
            this.singleWriterLockBehavior = swLockBehavior;
            this.scopedLockDetails = scopeDetails;
            this.backendLockTimeoutMillis = backendTimeout;
            this.minTxnLockTimeoutMillis = minTxnLockTimeout;
            this.maxTxnLockTimeoutMillis = maxTxnLockTimeout;
            this.retryAttempts = numRetries;
            this.replicateControl = replicate;
            this.returnResponseControl = responseControl;
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_TXN_SETTINGS_REQUEST_ERROR_DECODING_VALUE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @NotNull
    private static ASN1OctetString encodeValue(@Nullable String transactionName, @Nullable TransactionSettingsCommitDurability commitDurability, @Nullable TransactionSettingsBackendLockBehavior backendLockBehavior, @Nullable TransactionSettingsBackendLockBehavior singleWriterLockBehavior, @Nullable TransactionSettingsScopedLockDetails scopedLockDetails, @Nullable Long backendLockTimeoutMillis, @Nullable Integer retryAttempts, @Nullable Long minTxnLockTimeoutMillis, @Nullable Long maxTxnLockTimeoutMillis, boolean replicateControl, boolean returnResponseControl) {
        ASN1Element scopedLockDetailsElement;
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(10);
        if (transactionName != null) {
            elements.add(new ASN1OctetString(-128, transactionName));
        }
        if (commitDurability != null) {
            elements.add(new ASN1Enumerated(-127, commitDurability.intValue()));
        }
        if (backendLockBehavior != null) {
            elements.add(new ASN1Enumerated(-126, backendLockBehavior.intValue()));
        }
        if (backendLockTimeoutMillis != null) {
            Validator.ensureTrue(backendLockTimeoutMillis >= 0L, "If a backend lock timeout is specified, then it must be greater than or equal to zero.");
            elements.add(new ASN1Long(-125, backendLockTimeoutMillis));
        }
        if (retryAttempts != null) {
            Validator.ensureTrue(retryAttempts >= 0, "If specified, the number of retry attempts must be greater than or equal to zero.");
            elements.add(new ASN1Integer(-124, retryAttempts));
        }
        if (minTxnLockTimeoutMillis != null) {
            Validator.ensureTrue(maxTxnLockTimeoutMillis != null, "If a minimum transaction lock timeout is specified, then a maximum transaction lock timeout must also be specified.");
            Validator.ensureTrue(minTxnLockTimeoutMillis > 0L, "If a minimum transaction lock timeout is specified, then it must be greater than zero.");
            Validator.ensureTrue(maxTxnLockTimeoutMillis >= minTxnLockTimeoutMillis, "If a minimum transaction lock timeout is specified, then it must be less than or equal to the minimum transaction lock timeout.");
            elements.add(new ASN1Sequence(-91, new ASN1Long(minTxnLockTimeoutMillis), new ASN1Long(maxTxnLockTimeoutMillis)));
        } else {
            Validator.ensureTrue(maxTxnLockTimeoutMillis == null, "If a maximum transaction lock timeout is specified, then a minimum transaction lock timeout must also be specified.");
        }
        if (returnResponseControl) {
            elements.add(new ASN1Boolean(-122, true));
        }
        if (singleWriterLockBehavior != null) {
            elements.add(new ASN1Enumerated(-121, singleWriterLockBehavior.intValue()));
        }
        if (scopedLockDetails != null && (scopedLockDetailsElement = scopedLockDetails.encode()) != null) {
            elements.add(scopedLockDetailsElement);
        }
        if (replicateControl) {
            elements.add(new ASN1Boolean(-117, true));
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    @Nullable
    public String getTransactionName() {
        return this.transactionName;
    }

    @Nullable
    public TransactionSettingsCommitDurability getCommitDurability() {
        return this.commitDurability;
    }

    @Nullable
    public TransactionSettingsBackendLockBehavior getBackendLockBehavior() {
        return this.backendExclusiveLockBehavior;
    }

    @Nullable
    public TransactionSettingsBackendLockBehavior getSingleWriterLockBehavior() {
        return this.singleWriterLockBehavior;
    }

    @Nullable
    public TransactionSettingsScopedLockDetails getScopedLockDetails() {
        return this.scopedLockDetails;
    }

    @Nullable
    public Long getBackendLockTimeoutMillis() {
        return this.backendLockTimeoutMillis;
    }

    @Nullable
    public Integer getRetryAttempts() {
        return this.retryAttempts;
    }

    @Nullable
    public Long getMinTxnLockTimeoutMillis() {
        return this.minTxnLockTimeoutMillis;
    }

    @Nullable
    public Long getMaxTxnLockTimeoutMillis() {
        return this.maxTxnLockTimeoutMillis;
    }

    public boolean replicateControl() {
        return this.replicateControl;
    }

    public boolean returnResponseControl() {
        return this.returnResponseControl;
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_TXN_SETTINGS_REQUEST.get();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("TransactionSettingsRequestControl(isCritical=");
        buffer.append(this.isCritical());
        if (this.transactionName != null) {
            buffer.append(", transactionName='");
            buffer.append(this.transactionName);
            buffer.append('\'');
        }
        if (this.commitDurability != null) {
            buffer.append(", commitDurability='");
            buffer.append(this.commitDurability.name());
            buffer.append('\'');
        }
        if (this.backendExclusiveLockBehavior != null) {
            buffer.append(", backendExclusiveLockBehavior='");
            buffer.append(this.backendExclusiveLockBehavior.name());
            buffer.append('\'');
        }
        if (this.singleWriterLockBehavior != null) {
            buffer.append(", singleWriterLockBehavior='");
            buffer.append(this.singleWriterLockBehavior.name());
            buffer.append('\'');
        }
        if (this.scopedLockDetails != null) {
            buffer.append(", scopedLockDetails=");
            this.scopedLockDetails.toString(buffer);
        }
        if (this.backendLockTimeoutMillis != null) {
            buffer.append(", backendLockTimeoutMillis=");
            buffer.append(this.backendLockTimeoutMillis);
        }
        if (this.retryAttempts != null) {
            buffer.append(", retryAttempts=");
            buffer.append(this.retryAttempts);
        }
        if (this.minTxnLockTimeoutMillis != null) {
            buffer.append(", minTxnLockTimeoutMillis=");
            buffer.append(this.minTxnLockTimeoutMillis);
        }
        if (this.maxTxnLockTimeoutMillis != null) {
            buffer.append(", maxTxnLockTimeoutMillis=");
            buffer.append(this.maxTxnLockTimeoutMillis);
        }
        buffer.append(", replicateControl=");
        buffer.append(this.replicateControl);
        buffer.append(", returnResponseControl=");
        buffer.append(this.returnResponseControl);
        buffer.append(')');
    }
}

