/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testelement.property;

import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.NumberProperty;

public class DoubleProperty
extends NumberProperty {
    private static final long serialVersionUID = 240L;
    private double value;
    private double savedValue;

    public DoubleProperty(String name, double value) {
        super(name);
        this.value = value;
    }

    public DoubleProperty() {
    }

    public void setValue(float value) {
        this.value = value;
    }

    @Override
    protected void setNumberValue(Number n) {
        this.value = n.doubleValue();
    }

    @Override
    protected void setNumberValue(String n) throws NumberFormatException {
        this.value = Double.parseDouble(n);
    }

    @Override
    public String getStringValue() {
        return Double.toString(this.value);
    }

    @Override
    public Object getObjectValue() {
        return this.value;
    }

    @Override
    public DoubleProperty clone() {
        DoubleProperty prop = (DoubleProperty)super.clone();
        prop.value = this.value;
        return prop;
    }

    @Override
    public boolean getBooleanValue() {
        return this.value > 0.0;
    }

    @Override
    public double getDoubleValue() {
        return this.value;
    }

    @Override
    public float getFloatValue() {
        return (float)this.value;
    }

    @Override
    public int getIntValue() {
        return (int)this.value;
    }

    @Override
    public long getLongValue() {
        return (long)this.value;
    }

    @Override
    public void setRunningVersion(boolean runningVersion) {
        this.savedValue = this.value;
        super.setRunningVersion(runningVersion);
    }

    @Override
    public void recoverRunningVersion(TestElement owner) {
        this.value = this.savedValue;
    }
}

