/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.collections;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.util.JMeterError;

public class ListedHashTree
extends HashTree
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 240L;
    private final List<Object> order = new ArrayList<Object>();

    public ListedHashTree() {
    }

    public ListedHashTree(Object key) {
        this();
        this.data.put(key, new ListedHashTree());
        this.order.add(key);
    }

    public ListedHashTree(Collection<?> keys) {
        this();
        for (Object temp : keys) {
            this.data.put(temp, new ListedHashTree());
            this.order.add(temp);
        }
    }

    public ListedHashTree(Object[] keys) {
        this();
        for (Object key : keys) {
            this.data.put(key, new ListedHashTree());
            this.order.add(key);
        }
    }

    @Override
    public Object clone() {
        ListedHashTree newTree = new ListedHashTree();
        this.cloneTree(newTree);
        return newTree;
    }

    @Override
    public ListedHashTree getTree(Object key) {
        return (ListedHashTree)super.getTree(key);
    }

    @Override
    public void set(Object key, Object value) {
        if (!this.data.containsKey(key)) {
            this.order.add(key);
        }
        super.set(key, value);
    }

    @Override
    public void set(Object key, HashTree t) {
        if (!this.data.containsKey(key)) {
            this.order.add(key);
        }
        super.set(key, t);
    }

    @Override
    public void set(Object key, Object[] values) {
        if (!this.data.containsKey(key)) {
            this.order.add(key);
        }
        super.set(key, values);
    }

    @Override
    public void set(Object key, Collection<?> values) {
        if (!this.data.containsKey(key)) {
            this.order.add(key);
        }
        super.set(key, values);
    }

    @Override
    public void replaceKey(Object currentKey, Object newKey) {
        ListedHashTree tree = this.getTree(currentKey);
        this.data.remove(currentKey);
        this.data.put(newKey, tree);
        int entry = -1;
        for (int i = 0; i < this.order.size(); ++i) {
            Object ent = this.order.get(i);
            if (ent != currentKey) continue;
            entry = i;
            break;
        }
        if (entry == -1) {
            throw new JMeterError("Impossible state, data key not present in order: " + currentKey.getClass());
        }
        this.order.set(entry, newKey);
    }

    @Override
    public ListedHashTree createNewTree() {
        return new ListedHashTree();
    }

    @Override
    public ListedHashTree createNewTree(Object key) {
        return new ListedHashTree(key);
    }

    @Override
    public ListedHashTree createNewTree(Collection<?> values) {
        return new ListedHashTree(values);
    }

    @Override
    public ListedHashTree add(Object key) {
        if (!this.data.containsKey(key)) {
            ListedHashTree newTree = this.createNewTree();
            this.data.put(key, newTree);
            this.order.add(key);
            return newTree;
        }
        return this.getTree(key);
    }

    @Override
    public Collection<Object> list() {
        return this.order;
    }

    @Override
    public HashTree remove(Object key) {
        if (this.data.containsKey(key)) {
            this.order.removeIf(x -> x == key);
        }
        return (HashTree)this.data.remove(key);
    }

    @Override
    public Object[] getArray() {
        return this.order.toArray();
    }

    @Override
    public int hashCode() {
        int hc = 17;
        for (Object o : this.order) {
            hc = hc * 37 + System.identityHashCode(o);
        }
        hc = hc * 37 + super.hashCode();
        return hc;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ListedHashTree)) {
            return false;
        }
        ListedHashTree lht = (ListedHashTree)o;
        if (!super.equals(lht)) {
            return false;
        }
        for (int i = 0; i < this.order.size(); ++i) {
            if (this.order.get(i) == lht.order.get(i)) continue;
            return false;
        }
        return true;
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
    }

    @Override
    public void clear() {
        super.clear();
        this.order.clear();
    }
}

