/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.kendra.model.AttributeFilter;
import com.amazonaws.services.kendra.model.DocumentRelevanceConfiguration;
import com.amazonaws.services.kendra.model.UserContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RetrieveRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String indexId;
    private String queryText;
    private AttributeFilter attributeFilter;
    private List<String> requestedDocumentAttributes;
    private List<DocumentRelevanceConfiguration> documentRelevanceOverrideConfigurations;
    private Integer pageNumber;
    private Integer pageSize;
    private UserContext userContext;

    public void setIndexId(String indexId) {
        this.indexId = indexId;
    }

    public String getIndexId() {
        return this.indexId;
    }

    public RetrieveRequest withIndexId(String indexId) {
        this.setIndexId(indexId);
        return this;
    }

    public void setQueryText(String queryText) {
        this.queryText = queryText;
    }

    public String getQueryText() {
        return this.queryText;
    }

    public RetrieveRequest withQueryText(String queryText) {
        this.setQueryText(queryText);
        return this;
    }

    public void setAttributeFilter(AttributeFilter attributeFilter) {
        this.attributeFilter = attributeFilter;
    }

    public AttributeFilter getAttributeFilter() {
        return this.attributeFilter;
    }

    public RetrieveRequest withAttributeFilter(AttributeFilter attributeFilter) {
        this.setAttributeFilter(attributeFilter);
        return this;
    }

    public List<String> getRequestedDocumentAttributes() {
        return this.requestedDocumentAttributes;
    }

    public void setRequestedDocumentAttributes(Collection<String> requestedDocumentAttributes) {
        if (requestedDocumentAttributes == null) {
            this.requestedDocumentAttributes = null;
            return;
        }
        this.requestedDocumentAttributes = new ArrayList<String>(requestedDocumentAttributes);
    }

    public RetrieveRequest withRequestedDocumentAttributes(String ... requestedDocumentAttributes) {
        if (this.requestedDocumentAttributes == null) {
            this.setRequestedDocumentAttributes(new ArrayList<String>(requestedDocumentAttributes.length));
        }
        for (String ele : requestedDocumentAttributes) {
            this.requestedDocumentAttributes.add(ele);
        }
        return this;
    }

    public RetrieveRequest withRequestedDocumentAttributes(Collection<String> requestedDocumentAttributes) {
        this.setRequestedDocumentAttributes(requestedDocumentAttributes);
        return this;
    }

    public List<DocumentRelevanceConfiguration> getDocumentRelevanceOverrideConfigurations() {
        return this.documentRelevanceOverrideConfigurations;
    }

    public void setDocumentRelevanceOverrideConfigurations(Collection<DocumentRelevanceConfiguration> documentRelevanceOverrideConfigurations) {
        if (documentRelevanceOverrideConfigurations == null) {
            this.documentRelevanceOverrideConfigurations = null;
            return;
        }
        this.documentRelevanceOverrideConfigurations = new ArrayList<DocumentRelevanceConfiguration>(documentRelevanceOverrideConfigurations);
    }

    public RetrieveRequest withDocumentRelevanceOverrideConfigurations(DocumentRelevanceConfiguration ... documentRelevanceOverrideConfigurations) {
        if (this.documentRelevanceOverrideConfigurations == null) {
            this.setDocumentRelevanceOverrideConfigurations(new ArrayList<DocumentRelevanceConfiguration>(documentRelevanceOverrideConfigurations.length));
        }
        for (DocumentRelevanceConfiguration ele : documentRelevanceOverrideConfigurations) {
            this.documentRelevanceOverrideConfigurations.add(ele);
        }
        return this;
    }

    public RetrieveRequest withDocumentRelevanceOverrideConfigurations(Collection<DocumentRelevanceConfiguration> documentRelevanceOverrideConfigurations) {
        this.setDocumentRelevanceOverrideConfigurations(documentRelevanceOverrideConfigurations);
        return this;
    }

    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public RetrieveRequest withPageNumber(Integer pageNumber) {
        this.setPageNumber(pageNumber);
        return this;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public RetrieveRequest withPageSize(Integer pageSize) {
        this.setPageSize(pageSize);
        return this;
    }

    public void setUserContext(UserContext userContext) {
        this.userContext = userContext;
    }

    public UserContext getUserContext() {
        return this.userContext;
    }

    public RetrieveRequest withUserContext(UserContext userContext) {
        this.setUserContext(userContext);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIndexId() != null) {
            sb.append("IndexId: ").append(this.getIndexId()).append(",");
        }
        if (this.getQueryText() != null) {
            sb.append("QueryText: ").append(this.getQueryText()).append(",");
        }
        if (this.getAttributeFilter() != null) {
            sb.append("AttributeFilter: ").append(this.getAttributeFilter()).append(",");
        }
        if (this.getRequestedDocumentAttributes() != null) {
            sb.append("RequestedDocumentAttributes: ").append(this.getRequestedDocumentAttributes()).append(",");
        }
        if (this.getDocumentRelevanceOverrideConfigurations() != null) {
            sb.append("DocumentRelevanceOverrideConfigurations: ").append(this.getDocumentRelevanceOverrideConfigurations()).append(",");
        }
        if (this.getPageNumber() != null) {
            sb.append("PageNumber: ").append(this.getPageNumber()).append(",");
        }
        if (this.getPageSize() != null) {
            sb.append("PageSize: ").append(this.getPageSize()).append(",");
        }
        if (this.getUserContext() != null) {
            sb.append("UserContext: ").append(this.getUserContext());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetrieveRequest)) {
            return false;
        }
        RetrieveRequest other = (RetrieveRequest)obj;
        if (other.getIndexId() == null ^ this.getIndexId() == null) {
            return false;
        }
        if (other.getIndexId() != null && !other.getIndexId().equals(this.getIndexId())) {
            return false;
        }
        if (other.getQueryText() == null ^ this.getQueryText() == null) {
            return false;
        }
        if (other.getQueryText() != null && !other.getQueryText().equals(this.getQueryText())) {
            return false;
        }
        if (other.getAttributeFilter() == null ^ this.getAttributeFilter() == null) {
            return false;
        }
        if (other.getAttributeFilter() != null && !other.getAttributeFilter().equals(this.getAttributeFilter())) {
            return false;
        }
        if (other.getRequestedDocumentAttributes() == null ^ this.getRequestedDocumentAttributes() == null) {
            return false;
        }
        if (other.getRequestedDocumentAttributes() != null && !other.getRequestedDocumentAttributes().equals(this.getRequestedDocumentAttributes())) {
            return false;
        }
        if (other.getDocumentRelevanceOverrideConfigurations() == null ^ this.getDocumentRelevanceOverrideConfigurations() == null) {
            return false;
        }
        if (other.getDocumentRelevanceOverrideConfigurations() != null && !other.getDocumentRelevanceOverrideConfigurations().equals(this.getDocumentRelevanceOverrideConfigurations())) {
            return false;
        }
        if (other.getPageNumber() == null ^ this.getPageNumber() == null) {
            return false;
        }
        if (other.getPageNumber() != null && !other.getPageNumber().equals(this.getPageNumber())) {
            return false;
        }
        if (other.getPageSize() == null ^ this.getPageSize() == null) {
            return false;
        }
        if (other.getPageSize() != null && !other.getPageSize().equals(this.getPageSize())) {
            return false;
        }
        if (other.getUserContext() == null ^ this.getUserContext() == null) {
            return false;
        }
        return other.getUserContext() == null || other.getUserContext().equals(this.getUserContext());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIndexId() == null ? 0 : this.getIndexId().hashCode());
        hashCode = 31 * hashCode + (this.getQueryText() == null ? 0 : this.getQueryText().hashCode());
        hashCode = 31 * hashCode + (this.getAttributeFilter() == null ? 0 : this.getAttributeFilter().hashCode());
        hashCode = 31 * hashCode + (this.getRequestedDocumentAttributes() == null ? 0 : this.getRequestedDocumentAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getDocumentRelevanceOverrideConfigurations() == null ? 0 : this.getDocumentRelevanceOverrideConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.getPageNumber() == null ? 0 : this.getPageNumber().hashCode());
        hashCode = 31 * hashCode + (this.getPageSize() == null ? 0 : this.getPageSize().hashCode());
        hashCode = 31 * hashCode + (this.getUserContext() == null ? 0 : this.getUserContext().hashCode());
        return hashCode;
    }

    public RetrieveRequest clone() {
        return (RetrieveRequest)super.clone();
    }
}

