/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.blackbird.util;

import com.fasterxml.jackson.module.blackbird.util.CheckedFunction;
import com.fasterxml.jackson.module.blackbird.util.CheckedSupplier;
import com.fasterxml.jackson.module.blackbird.util.Sneaky;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Supplier;

public class Unchecked {
    private Unchecked() {
        throw new RuntimeException();
    }

    public static Runnable runnable(CheckedRunnable checkedRunnable) {
        return () -> {
            try {
                checkedRunnable.run();
            }
            catch (Throwable t) {
                throw Sneaky.throwAnyway(t);
            }
        };
    }

    public static <T> Supplier<T> supplier(CheckedSupplier<T> checkedSupplier) {
        return () -> {
            try {
                return checkedSupplier.get();
            }
            catch (Throwable t) {
                throw Sneaky.throwAnyway(t);
            }
        };
    }

    public static <X, T> Function<X, T> function(CheckedFunction<X, T> checkedFunction) {
        return x -> {
            try {
                return checkedFunction.apply(x);
            }
            catch (Throwable t) {
                throw Sneaky.throwAnyway(t);
            }
        };
    }

    public static interface CheckedRunnable {
        public void run() throws Throwable;
    }

    public static interface SneakyCallable<T>
    extends Callable<T> {
        @Override
        public T call();
    }
}

