/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.url;

import aQute.bnd.url.DefaultURLConnectionHandler;
import aQute.lib.base64.Base64;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicAuthentication
extends DefaultURLConnectionHandler {
    private static final String USER = "user";
    private static final String PASSWORD = ".password";
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private static final String PREFIX_BASIC_AUTH = "Basic ";
    private String password;
    private String user;
    private String authentication;

    @Override
    public void setProperties(Map<String, String> map) throws Exception {
        super.setProperties(map);
        this.password = map.get(PASSWORD);
        this.user = map.get(USER);
        if (this.password == null) {
            this.error("No .password property set on this plugin %s", map);
        }
        if (this.password == null) {
            this.error("No user property set on this plugin %s", map);
        }
        String authString = this.user + ":" + this.password;
        try {
            String encoded = Base64.encodeBase64(authString.getBytes("UTF-8"));
            this.authentication = PREFIX_BASIC_AUTH + encoded;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    @Override
    public void handle(URLConnection connection) {
        if (connection instanceof HttpURLConnection && this.matches(connection) && this.password != null && this.user != null) {
            if (!(connection instanceof HttpsURLConnection)) {
                this.trace("using basic authentication with http instead of https, this is very insecure: %s", connection.getURL());
            }
            connection.setRequestProperty(HEADER_AUTHORIZATION, this.authentication);
        }
    }
}

