/*
 * Decompiled with CFR 0.152.
 */
package org.jledit.command.editor;

import org.jledit.ConsoleEditor;
import org.jledit.command.editor.AbstractUndoableCommand;
import org.jledit.command.editor.Position;

public class NewLineCommand
extends AbstractUndoableCommand {
    private final Position position;

    public NewLineCommand(ConsoleEditor editor) {
        this(editor, Position.CURRENT);
    }

    public NewLineCommand(ConsoleEditor editor, Position position) {
        super(editor);
        this.position = position;
    }

    @Override
    public void doExecute() {
        if (!this.getEditor().isReadOnly()) {
            this.getEditor().setDirty(true);
            switch (this.position) {
                case CURRENT: {
                    this.getEditor().newLine();
                    break;
                }
                case NEXT_LINE: {
                    this.getEditor().moveToEndOfLine();
                    this.getEditor().newLine();
                    break;
                }
                case PREVIOUS_LINE: {
                    this.getEditor().moveToStartOfLine();
                    this.getEditor().newLine();
                    this.getEditor().moveUp(1);
                }
            }
        }
    }

    @Override
    public void undo() {
        if (!this.getEditor().isReadOnly()) {
            switch (this.position) {
                case CURRENT: 
                case NEXT_LINE: {
                    this.getEditor().move(this.getBeforeLine(), this.getBeforeColumn());
                    this.getEditor().mergeLine();
                    break;
                }
                case PREVIOUS_LINE: {
                    this.getEditor().move(this.getBeforeLine() - 1, this.getBeforeColumn());
                    this.getEditor().mergeLine();
                }
            }
        }
    }
}

