/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.component.spi;

import java.io.PrintStream;

public class ErrorItem {
    String message;
    int colNumber = -1;
    int lineNumber = -1;
    Throwable exception;

    public ErrorItem(String message, Exception e) {
        this.message = message;
        this.exception = e;
    }

    public ErrorItem(String message) {
        this(message, null);
    }

    public int getColNumber() {
        return this.colNumber;
    }

    public void setColNumber(int colNumber) {
        this.colNumber = colNumber;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String toString() {
        String str = "Reported error: \"" + this.message + "\"";
        if (this.lineNumber != -1) {
            str = str + " at line " + this.lineNumber + " column " + this.colNumber;
        }
        if (this.exception != null) {
            str = str + " with exception " + this.exception;
        }
        return str;
    }

    public void dump() {
        this.dump(System.out);
    }

    public void dump(PrintStream ps) {
        String str = "Reported error: \"" + this.message + "\"";
        if (this.lineNumber != -1) {
            str = str + " at line " + this.lineNumber + " column " + this.colNumber;
        }
        ps.println(str);
        if (this.exception != null) {
            this.exception.printStackTrace(ps);
        }
    }
}

