/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.bundle.command;

import org.apache.karaf.bundle.command.BundlesCommand;
import org.apache.karaf.bundle.core.BundleInfo;
import org.apache.karaf.bundle.core.BundleState;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.ShellUtil;
import org.osgi.framework.Bundle;

@Command(scope="bundle", name="diag", description="Displays diagnostic information why a bundle is not Active")
@Service
public class Diag
extends BundlesCommand {
    @Override
    protected void executeOnBundle(Bundle bundle) throws Exception {
        BundleInfo info = this.bundleService.getInfo(bundle);
        if (info.getState() == BundleState.Failure || info.getState() == BundleState.Waiting || info.getState() == BundleState.GracePeriod || info.getState() == BundleState.Installed) {
            String title = ShellUtil.getBundleName((Bundle)bundle);
            System.out.println(title);
            System.out.println(ShellUtil.getUnderlineString((String)title));
            System.out.println("Status: " + info.getState().toString());
            System.out.println(this.bundleService.getDiag(bundle));
            System.out.println();
        }
    }
}

