/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm.model.kudu;

import com.cloudera.api.swagger.client.ApiException;
import com.cloudera.api.swagger.model.ApiConfigList;
import com.cloudera.api.swagger.model.ApiRole;
import com.cloudera.api.swagger.model.ApiService;
import com.cloudera.api.swagger.model.ApiServiceConfig;
import java.util.Locale;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModel;
import org.apache.knox.gateway.topology.discovery.cm.model.AbstractServiceModelGenerator;

public class KuduUIServiceModelGenerator
extends AbstractServiceModelGenerator {
    public static final String SERVICE = "KUDUUI";
    public static final String SERVICE_TYPE = "KUDU";
    public static final String ROLE_TYPE = "KUDU_MASTER";
    static final String WEBSERVER_PORT = "webserver_port";
    static final String SSL_ENABLED = "ssl_enabled";

    @Override
    public String getService() {
        return SERVICE;
    }

    @Override
    public String getServiceType() {
        return SERVICE_TYPE;
    }

    @Override
    public String getRoleType() {
        return ROLE_TYPE;
    }

    @Override
    public ServiceModel.Type getModelType() {
        return ServiceModel.Type.UI;
    }

    @Override
    public ServiceModel generateService(ApiService service, ApiServiceConfig serviceConfig, ApiRole role, ApiConfigList roleConfig, ApiServiceConfig coreSettingsConfig) throws ApiException {
        String hostname = role.getHostRef().getHostname();
        String sslEnabled = this.getRoleConfigValue(roleConfig, SSL_ENABLED);
        String scheme = Boolean.parseBoolean(sslEnabled) ? "https" : "http";
        String port = this.getRoleConfigValue(roleConfig, WEBSERVER_PORT);
        ServiceModel model = this.createServiceModel(String.format(Locale.getDefault(), "%s://%s:%s/", scheme, hostname, port));
        model.addRoleProperty(this.getRoleType(), SSL_ENABLED, sslEnabled);
        model.addRoleProperty(this.getRoleType(), WEBSERVER_PORT, port);
        return model;
    }
}

