/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterFilter {
    private static final Logger logger = LoggerFactory.getLogger(ParameterFilter.class);
    public static final String PARAMETER_REGULAR_EXPRESSION = "[ &`>|{}()$;\\-#~!+*\\\\]+";
    public static final String URI_REGULAR_EXPRESSION = "[^\\w%,@/:=?.\"\\[\\]]";
    public static final String HIVE_PROPERTY_REGULAR_EXPRESSION = "[ <>()$;\\-#!+*\"'/=%@]+";
    public static final String SPARK_CONF_REGULAR_EXPRESSION = "[`$|&;]+";

    public static String checkParameter(String commandParameter) {
        return ParameterFilter.checkParameter(commandParameter, PARAMETER_REGULAR_EXPRESSION, false);
    }

    public static String checkURI(String commandParameter) {
        return ParameterFilter.checkParameter(commandParameter, URI_REGULAR_EXPRESSION, false);
    }

    public static String checkHiveProperty(String hiveProperty) {
        return ParameterFilter.checkParameter(hiveProperty, HIVE_PROPERTY_REGULAR_EXPRESSION, false);
    }

    public static String checkSparkConf(String sparkConf) {
        return ParameterFilter.checkParameter(sparkConf, SPARK_CONF_REGULAR_EXPRESSION, true);
    }

    private static String checkParameter(String commandParameter, String rex, boolean throwException) {
        String repaired = commandParameter.replaceAll(rex, "");
        if (repaired.length() != commandParameter.length()) {
            if (throwException) {
                throw new IllegalArgumentException("Detected illegal character in " + commandParameter + " by " + rex);
            }
            logger.warn("Detected illegal character in command {} by {} , replace it to {}.", commandParameter, rex, repaired);
        }
        return repaired;
    }
}

