/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.DictionaryDesc;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.IJoinedFlatTableDesc;
import org.apache.kylin.metadata.model.ISegment;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Maps;

public class CubeJoinedFlatTableDesc
implements IJoinedFlatTableDesc,
Serializable {
    protected String tableName;
    protected final CubeDesc cubeDesc;
    protected final CubeSegment cubeSegment;
    protected final boolean includingDerived;
    private int columnCount = 0;
    private List<TblColRef> columnList = Lists.newArrayList();
    private Map<TblColRef, Integer> columnIndexMap = Maps.newHashMap();

    public CubeJoinedFlatTableDesc(CubeDesc cubeDesc) {
        this(cubeDesc, null, false);
    }

    public CubeJoinedFlatTableDesc(CubeDesc cubeDesc, boolean includingDerived) {
        this(cubeDesc, null, includingDerived);
    }

    public CubeJoinedFlatTableDesc(CubeSegment cubeSegment) {
        this(cubeSegment.getCubeDesc(), cubeSegment, false);
    }

    public CubeJoinedFlatTableDesc(CubeSegment cubeSegment, boolean includingDerived) {
        this(cubeSegment.getCubeDesc(), cubeSegment, includingDerived);
    }

    private CubeJoinedFlatTableDesc(CubeDesc cubeDesc, CubeSegment cubeSegment, boolean includingDerived) {
        this.cubeDesc = cubeDesc;
        this.cubeSegment = cubeSegment;
        this.tableName = this.makeTableName(cubeDesc, cubeSegment);
        this.includingDerived = includingDerived;
        this.initParseCubeDesc();
    }

    protected String makeTableName(CubeDesc cubeDesc, CubeSegment cubeSegment) {
        if (cubeSegment == null) {
            return cubeDesc.getConfig().getHiveIntermediateTablePrefix() + cubeDesc.getName().toLowerCase(Locale.ROOT);
        }
        return cubeDesc.getConfig().getHiveIntermediateTablePrefix() + cubeDesc.getName().toLowerCase(Locale.ROOT) + "_" + cubeSegment.getUuid().replaceAll("-", "_");
    }

    protected final void initAddColumn(TblColRef col) {
        if (this.columnIndexMap.containsKey(col)) {
            return;
        }
        int columnIndex = this.columnIndexMap.size();
        this.columnIndexMap.put(col, columnIndex);
        this.columnList.add(col);
        this.columnCount = this.columnIndexMap.size();
        Preconditions.checkState(this.columnIndexMap.size() == this.columnList.size());
    }

    protected void initParseCubeDesc() {
        if (this.includingDerived) {
            for (TblColRef col : this.cubeDesc.listDimensionColumnsIncludingDerived()) {
                this.initAddColumn(col);
            }
        } else {
            for (TblColRef col : this.cubeDesc.listDimensionColumnsExcludingDerived(false)) {
                this.initAddColumn(col);
            }
        }
        List<MeasureDesc> measures = this.cubeDesc.getMeasures();
        int measureSize = measures.size();
        for (int i = 0; i < measureSize; ++i) {
            FunctionDesc func = measures.get(i).getFunction();
            List<TblColRef> colRefs = func.getParameter().getColRefs();
            if (colRefs == null) continue;
            for (int j = 0; j < colRefs.size(); ++j) {
                TblColRef c = colRefs.get(j);
                this.initAddColumn(c);
            }
        }
        if (this.cubeDesc.getDictionaries() != null) {
            for (DictionaryDesc dictDesc : this.cubeDesc.getDictionaries()) {
                TblColRef c = dictDesc.getColumnRef();
                this.initAddColumn(c);
                if (dictDesc.getResuseColumnRef() == null) continue;
                c = dictDesc.getResuseColumnRef();
                this.initAddColumn(c);
            }
        }
    }

    @Override
    public List<TblColRef> getFactColumns() {
        ArrayList<TblColRef> factColumns = Lists.newArrayList();
        for (TblColRef col : this.getAllColumns()) {
            if (!col.getTableRef().equals(this.getDataModel().getRootFactTable())) continue;
            factColumns.add(col);
        }
        return factColumns;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public List<TblColRef> getAllColumns() {
        return this.columnList;
    }

    @Override
    public DataModelDesc getDataModel() {
        return this.cubeDesc.getModel();
    }

    @Override
    public int getColumnIndex(TblColRef colRef) {
        Integer index = this.columnIndexMap.get(colRef);
        if (index == null) {
            return -1;
        }
        return index;
    }

    @Override
    public SegmentRange getSegRange() {
        if (this.cubeSegment.isOffsetCube()) {
            return null;
        }
        return this.cubeSegment.getSegRange();
    }

    @Override
    public TblColRef getDistributedBy() {
        return this.cubeDesc.getDistributedByColumn();
    }

    @Override
    public ISegment getSegment() {
        return this.cubeSegment;
    }

    @Override
    public boolean useAlias() {
        return true;
    }

    @Override
    public TblColRef getClusterBy() {
        return this.cubeDesc.getClusteredByColumn();
    }
}

