/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.CubeJoinedFlatTableEnrich;
import org.apache.kylin.measure.hllc.HLLCounter;
import org.apache.kylin.metadata.model.IJoinedFlatTableDesc;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.shaded.com.google.common.hash.HashFunction;
import org.apache.kylin.shaded.com.google.common.hash.Hasher;
import org.apache.kylin.shaded.com.google.common.hash.Hashing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubingUtils {
    private static Logger logger = LoggerFactory.getLogger(CubingUtils.class);

    public static Map<Long, HLLCounter> sampling(CubeDesc cubeDesc, IJoinedFlatTableDesc flatDescIn, Iterable<List<String>> streams) {
        CubeJoinedFlatTableEnrich flatDesc = new CubeJoinedFlatTableEnrich(flatDescIn, cubeDesc);
        int rowkeyLength = cubeDesc.getRowkey().getRowKeyColumns().length;
        Set<Long> allCuboidIds = cubeDesc.getInitialCuboidScheduler().getAllCuboidIds();
        long baseCuboidId = Cuboid.getBaseCuboidId(cubeDesc);
        HashMap<Long, Integer[]> allCuboidsBitSet = Maps.newHashMap();
        HashMap<Long, HLLCounter> result = Maps.newHashMapWithExpectedSize(allCuboidIds.size());
        for (Long cuboidId : allCuboidIds) {
            result.put(cuboidId, new HLLCounter(cubeDesc.getConfig().getCubeStatsHLLPrecision()));
            Integer[] cuboidBitSet = new Integer[Long.bitCount(cuboidId)];
            long mask = Long.highestOneBit(baseCuboidId);
            int position = 0;
            for (int i = 0; i < rowkeyLength; ++i) {
                if ((mask & cuboidId) > 0L) {
                    cuboidBitSet[position] = i;
                    ++position;
                }
                mask >>= 1;
            }
            allCuboidsBitSet.put(cuboidId, cuboidBitSet);
        }
        HashFunction hf = Hashing.murmur3_32();
        byte[][] row_hashcodes = new byte[rowkeyLength][];
        for (List<String> row : streams) {
            for (int i = 0; i < rowkeyLength; ++i) {
                Hasher hc = hf.newHasher();
                String cell = row.get(flatDesc.getRowKeyColumnIndexes()[i]);
                row_hashcodes[i] = cell != null ? hc.putUnencodedChars(cell).hash().asBytes() : hc.putInt(0).hash().asBytes();
            }
            for (Map.Entry longHyperLogLogPlusCounterNewEntry : result.entrySet()) {
                Long cuboidId = (Long)longHyperLogLogPlusCounterNewEntry.getKey();
                HLLCounter counter = (HLLCounter)longHyperLogLogPlusCounterNewEntry.getValue();
                Hasher hc = hf.newHasher();
                Integer[] cuboidBitSet = (Integer[])allCuboidsBitSet.get(cuboidId);
                for (int position = 0; position < cuboidBitSet.length; ++position) {
                    hc.putBytes(row_hashcodes[cuboidBitSet[position]]);
                }
                counter.add(hc.hash().asBytes());
            }
        }
        return result;
    }
}

