/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kylin.common.constant.JobTypeEnum;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.job.constant.JobStatusEnum;
import org.apache.kylin.job.constant.JobStepCmdTypeEnum;
import org.apache.kylin.job.constant.JobStepStatusEnum;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.annotation.JsonBackReference;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.annotation.JsonManagedReference;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.kylin.tool.shaded.org.apache.commons.lang3.StringUtils;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class JobInstance
extends RootPersistentEntity
implements Comparable<JobInstance> {
    public static final String YARN_APP_URL = "yarn_application_tracking_url";
    public static final String MR_JOB_ID = "mr_job_id";
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="projectName")
    private String projectName;
    @JsonProperty(value="type")
    private JobTypeEnum type;
    @JsonProperty(value="duration")
    private long duration;
    @JsonProperty(value="related_object")
    private String relatedObject;
    @JsonProperty(value="related_cube")
    private String relatedCube;
    @JsonProperty(value="display_cube_name")
    private String displayCubeName;
    @JsonProperty(value="related_segment")
    private String relatedSegment;
    @JsonProperty(value="related_segment_name")
    private String relatedSegmentName;
    @JsonProperty(value="exec_start_time")
    private long execStartTime;
    @JsonProperty(value="exec_end_time")
    private long execEndTime;
    @JsonProperty(value="exec_interrupt_time")
    private long execInterruptTime;
    @JsonProperty(value="mr_waiting")
    private long mrWaiting = 0L;
    @JsonManagedReference
    @JsonProperty(value="steps")
    private List<JobStep> steps;
    @JsonProperty(value="submitter")
    private String submitter;
    @JsonProperty(value="job_status")
    private JobStatusEnum status;
    @JsonProperty(value="build_instance")
    private String buildInstance;

    public JobStep getRunningStep() {
        for (JobStep step : this.getSteps()) {
            if (!step.getStatus().equals((Object)JobStepStatusEnum.RUNNING) && !step.getStatus().equals((Object)JobStepStatusEnum.WAITING)) continue;
            return step;
        }
        return null;
    }

    @JsonProperty(value="progress")
    public double getProgress() {
        int completedStepCount = 0;
        for (JobStep step : this.getSteps()) {
            if (!step.getStatus().equals((Object)JobStepStatusEnum.FINISHED)) continue;
            ++completedStepCount;
        }
        return 100.0 * (double)completedStepCount / (double)this.steps.size();
    }

    public JobStatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(JobStatusEnum status) {
        this.status = status;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public JobTypeEnum getType() {
        return this.type;
    }

    public void setType(JobTypeEnum type) {
        this.type = type;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public String getRelatedObject() {
        return this.relatedObject;
    }

    public void setRelatedObject(String relatedObject) {
        this.relatedObject = relatedObject;
    }

    public String getRelatedCube() {
        return this.relatedCube;
    }

    public void setRelatedCube(String relatedCube) {
        this.relatedCube = relatedCube;
    }

    public String getDisplayCubeName() {
        if (StringUtils.isBlank(this.displayCubeName)) {
            return this.relatedCube;
        }
        return this.displayCubeName;
    }

    public void setDisplayCubeName(String displayCubeName) {
        this.displayCubeName = displayCubeName;
    }

    public String getRelatedSegment() {
        return this.relatedSegment;
    }

    public void setRelatedSegment(String relatedSegment) {
        this.relatedSegment = relatedSegment;
    }

    public String getRelatedSegmentName() {
        return this.relatedSegmentName;
    }

    public void setRelatedSegmentName(String relatedSegmentName) {
        this.relatedSegmentName = relatedSegmentName;
    }

    public long getExecStartTime() {
        return this.execStartTime;
    }

    public void setExecStartTime(long execStartTime) {
        this.execStartTime = execStartTime;
    }

    public long getExecEndTime() {
        return this.execEndTime;
    }

    public long getExecInterruptTime() {
        return this.execInterruptTime;
    }

    public void setExecInterruptTime(long execInterruptTime) {
        this.execInterruptTime = execInterruptTime;
    }

    public void setExecEndTime(long execEndTime) {
        this.execEndTime = execEndTime;
    }

    public long getMrWaiting() {
        return this.mrWaiting;
    }

    public void setMrWaiting(long mrWaiting) {
        this.mrWaiting = mrWaiting;
    }

    public List<JobStep> getSteps() {
        if (this.steps == null) {
            this.steps = Lists.newArrayList();
        }
        return this.steps;
    }

    public void clearSteps() {
        this.getSteps().clear();
    }

    public void addSteps(Collection<JobStep> steps) {
        this.getSteps().addAll(steps);
    }

    public void addStep(JobStep step) {
        this.getSteps().add(step);
    }

    public void addStep(int index, JobStep step) {
        this.getSteps().add(index, step);
    }

    public JobStep findStep(String stepName) {
        for (JobStep step : this.getSteps()) {
            if (!stepName.equals(step.getName())) continue;
            return step;
        }
        return null;
    }

    public String getSubmitter() {
        return this.submitter;
    }

    public void setSubmitter(String submitter) {
        this.submitter = submitter;
    }

    public String getBuildInstance() {
        return this.buildInstance;
    }

    public void setBuildInstance(String buildInstance) {
        this.buildInstance = buildInstance;
    }

    @Override
    public int compareTo(JobInstance o) {
        return o.lastModified < this.lastModified ? -1 : (o.lastModified > this.lastModified ? 1 : 0);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class JobStep
    implements Comparable<JobStep> {
        @JsonBackReference
        private JobInstance jobInstance;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="sequence_id")
        private int sequenceID;
        @JsonProperty(value="exec_cmd")
        private String execCmd;
        @JsonProperty(value="interrupt_cmd")
        private String InterruptCmd;
        @JsonProperty(value="exec_start_time")
        private long execStartTime;
        @JsonProperty(value="exec_end_time")
        private long execEndTime;
        @JsonProperty(value="exec_wait_time")
        private long execWaitTime;
        @JsonProperty(value="step_status")
        private JobStepStatusEnum status = JobStepStatusEnum.PENDING;
        @JsonProperty(value="cmd_type")
        private JobStepCmdTypeEnum cmdType = JobStepCmdTypeEnum.SHELL_CMD_HADOOP;
        @JsonProperty(value="info")
        private ConcurrentHashMap<String, String> info = new ConcurrentHashMap();
        @JsonProperty(value="run_async")
        private boolean runAsync = false;

        private ConcurrentHashMap<String, String> getInfo() {
            return this.info;
        }

        public void putInfo(String key, String value) {
            this.getInfo().put(key, value);
        }

        public String getInfo(String key) {
            return this.getInfo().get(key);
        }

        public void clearInfo() {
            this.getInfo().clear();
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getSequenceID() {
            return this.sequenceID;
        }

        public void setSequenceID(int sequenceID) {
            this.sequenceID = sequenceID;
        }

        public String getExecCmd() {
            return this.execCmd;
        }

        public void setExecCmd(String execCmd) {
            this.execCmd = execCmd;
        }

        public JobStepStatusEnum getStatus() {
            return this.status;
        }

        public void setStatus(JobStepStatusEnum status) {
            this.status = status;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public long getExecStartTime() {
            return this.execStartTime;
        }

        public void setExecStartTime(long execStartTime) {
            this.execStartTime = execStartTime;
        }

        public long getExecEndTime() {
            return this.execEndTime;
        }

        public void setExecEndTime(long execEndTime) {
            this.execEndTime = execEndTime;
        }

        public long getExecWaitTime() {
            return this.execWaitTime;
        }

        public void setExecWaitTime(long execWaitTime) {
            this.execWaitTime = execWaitTime;
        }

        public String getInterruptCmd() {
            return this.InterruptCmd;
        }

        public void setInterruptCmd(String interruptCmd) {
            this.InterruptCmd = interruptCmd;
        }

        public JobStepCmdTypeEnum getCmdType() {
            return this.cmdType;
        }

        public void setCmdType(JobStepCmdTypeEnum cmdType) {
            this.cmdType = cmdType;
        }

        public boolean isRunAsync() {
            return this.runAsync;
        }

        public void setRunAsync(boolean runAsync) {
            this.runAsync = runAsync;
        }

        public JobInstance getJobInstance() {
            return this.jobInstance;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + this.sequenceID;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            JobStep other = (JobStep)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return this.sequenceID == other.sequenceID;
        }

        @Override
        public int compareTo(JobStep o) {
            if (this.sequenceID < o.sequenceID) {
                return -1;
            }
            if (this.sequenceID > o.sequenceID) {
                return 1;
            }
            return 0;
        }
    }
}

